/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rentsoft.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.SubscribtionStatus;

public class SubscribtionStatusManager
extends AbstarctDaoConstant {
    public SubscribtionStatusManager(Connection con, int moduleId) {
        super(con, "rentsoft_subscribtion_product", moduleId);
    }

    public void updateStatus(SubscribtionStatus status) throws SQLException {
        boolean update = false;
        String query = "UPDATE " + this.tableName + " SET status=? WHERE cid=? AND pid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, status.getStatus());
            ps.setInt(2, status.getContractId());
            ps.setInt(3, status.getProductId());
            update = ps.executeUpdate() > 0;
        }
        if (!update) {
            query = "INSERT INTO " + this.tableName + " SET status=?, cid=?, pid=?";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, status.getStatus());
                ps.setInt(2, status.getContractId());
                ps.setInt(3, status.getProductId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    public List<SubscribtionStatus> getList(int contractId) throws SQLException {
        ArrayList<SubscribtionStatus> result = new ArrayList<SubscribtionStatus>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    SubscribtionStatus ss = new SubscribtionStatus().setContractId(rs.getInt("cid")).setProductId(rs.getInt("pid")).setStatus(rs.getInt("status"));
                    result.add(ss);
                }
            }
        }
        return result;
    }

    public void deleteForContract(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }
}

