/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.action.web;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.drweb.common.bean.AgentAVD;
import ru.bitel.bgbilling.modules.drweb.common.bean.TariffAVD;
import ru.bitel.bgbilling.modules.drweb.server.bean.DrWebManager;
import ru.bitel.bgbilling.modules.drweb.server.bean.TariffAVDManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebAction(title="DrWeb")
public class ActionDrWeb
extends AbstractAction {
    public ActionDrWeb() {
        super("drweb");
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0430\u0433\u0435\u043d\u0442\u043e\u0432")
    public void agents() throws Exception {
        this.setResultParam("downloadUrl", this.moduleSetup.get("drweb.download.url", ""));
        this.setResultParam("agents", new DrWebManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId).getAgentList(this.contractId));
        this.setResultParam("maxAgentCount", this.moduleSetup.getInt("drweb.agent.max.count", -1));
        this.requestDispatcher(this.moduleName, "agents");
    }

    @WebOperation(title="\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u0433\u0435\u043d\u0442\u043e\u043c")
    public void change() throws Exception {
        this.setResultParam("agent", new DrWebManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId).getAgent(this.req.getInt("agentId", -1)));
        this.setResultParam("tariffs", this.getTariffs(false));
        this.setResultParam("downloadUrl", this.moduleSetup.get("drweb.download.url", ""));
        this.requestDispatcher(this.moduleName, "agent_edit");
    }

    @WebOperation(title="\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u0433\u0435\u043d\u0442\u0430 (\u0448\u0430\u0433 1)")
    public void addAgent1() throws Exception {
        try {
            new DrWebManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId).checkMaxAgentCount(this.contractId);
            this.setResultParam("tariffs", this.getTariffs(true));
        }
        catch (Exception ex) {
            this.setResultParam("error", ex.getMessage());
        }
        this.requestDispatcher(this.moduleName, "agent_add1");
    }

    @WebOperation(title="\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u0433\u0435\u043d\u0442\u0430 (\u0448\u0430\u0433 2)")
    public void addAgent2() throws Exception {
        try {
            int tariffId = this.req.getInt("tariffId", 0);
            DrWebManager drWebManager = new DrWebManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId);
            drWebManager.checkMaxAgentCount(this.contractId);
            if (!this.getTariffs(true).stream().anyMatch(a -> a.getId() == tariffId)) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0442\u0430\u0440\u0438\u0444\u0430");
            }
            this.setResultParam("agent", drWebManager.newAgent(this.contractId, tariffId));
            this.setResultParam("downloadUrl", this.moduleSetup.get("drweb.download.url", ""));
        }
        catch (Exception ex) {
            this.setResultParam("error", ex.getMessage());
        }
        this.requestDispatcher(this.moduleName, "agent_add2");
    }

    @WebOperation(title="\u0421\u043c\u0435\u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u0430")
    public void changeTariff() throws BGException {
        ActionMessage message = new ActionMessage("drwebRoot", "agents", "drwebQuery", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
        message.setOnClose("redirect");
        try {
            int tariffId = this.req.getInt("tariffId", 0);
            DrWebManager drWebManager = new DrWebManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId);
            AgentAVD agent = drWebManager.getAgent(this.req.getInt("agentId", -1));
            if (agent == null || agent.getContractId() != this.contractId) {
                message.setOnClose("close");
                message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0410\u0433\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else if (tariffId != -1 && this.getTariffs(false).stream().anyMatch(a -> a.getId() == tariffId)) {
                drWebManager.toChangeTariff(agent, tariffId);
                message.setError(agent.getNextStatusString());
            } else {
                message.setOnClose("close");
                message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0422\u0430\u0440\u0438\u0444 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
        }
        catch (Exception ex) {
            message.setOnClose("close");
            message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: " + ex.getMessage());
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    @WebOperation(title="\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430")
    public void block() throws BGException {
        ActionMessage message = new ActionMessage("drwebRoot", "agents", "drwebQuery", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
        message.setOnClose("redirect");
        try {
            int monthCount = this.req.getInt("monthCount", -1);
            DrWebManager drWebManager = new DrWebManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId);
            AgentAVD agent = drWebManager.getAgent(this.req.getInt("agentId", -1));
            if (agent == null || agent.getContractId() != this.contractId) {
                message.setOnClose("close");
                message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0410\u0433\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else if (monthCount > 0 && monthCount < 4) {
                drWebManager.blockAgent(agent, monthCount);
            } else {
                message.setOnClose("close");
                message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434");
            }
        }
        catch (Exception ex) {
            throw new BGMessageException(ex.getMessage());
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    @WebOperation(title="\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430")
    public void delete() throws SQLException, BGException {
        ActionMessage message = new ActionMessage("drwebRoot", "agents", "drwebQuery", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
        message.setOnClose("redirect");
        try {
            DrWebManager drWebManager = new DrWebManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId);
            AgentAVD agent = drWebManager.getAgent(this.req.getInt("agentId", -1));
            if (agent == null || agent.getContractId() != this.contractId) {
                message.setOnClose("close");
                message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0410\u0433\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else {
                drWebManager.deleteAgent(agent);
            }
        }
        catch (Exception ex) {
            throw new BGMessageException(ex.getMessage());
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    @WebOperation(title="\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f")
    public void active() throws SQLException, BGException {
        ActionMessage message = new ActionMessage("drwebRoot", "agents", "drwebQuery", "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430");
        message.setOnClose("redirect");
        try {
            DrWebManager drWebManager = new DrWebManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId);
            AgentAVD agent = drWebManager.getAgent(this.req.getInt("agentId", -1));
            if (agent == null || agent.getContractId() != this.contractId) {
                message.setOnClose("close");
                message.setError("\u041e\u0428\u0418\u0411\u041a\u0410: \u0410\u0433\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else {
                drWebManager.activeAgent(agent);
            }
        }
        catch (Exception ex) {
            throw new BGMessageException(ex.getMessage());
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    protected List<TariffAVD> getTariffs(boolean forNew) throws Exception {
        ArrayList<TariffAVD> res = new ArrayList<TariffAVD>();
        TariffAVDManager tariffManager = new TariffAVDManager(this.con, this.moduleId);
        Contract contract = ContractDao.getContract((Connection)this.con, (int)this.contractId);
        if (contract != null) {
            for (TariffAVD tariff : tariffManager.getListAll()) {
                String groupStr = tariff.getGroupForView();
                if (!Utils.isEmptyString((String)groupStr)) {
                    long grTariff = Utils.enumToMask((String)groupStr);
                    if ((contract.getGroups() & grTariff) == 0L) continue;
                }
                if (!forNew && tariff.isOnlyForNew()) continue;
                Date date = new Date();
                Date from = tariff.getDateFromView();
                Date to = tariff.getDateToView();
                if (from != null && !TimeUtils.dateBeforeOrEq((Date)from, (Date)date) || to != null && !TimeUtils.dateBeforeOrEq((Date)date, (Date)to)) continue;
                res.add(tariff);
            }
        }
        return res;
    }
}

