/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import bitel.billing.server.contract.bean.ContractManager;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.common.util.MacrosFormat;

public class BGMacrosFormat
extends MacrosFormat {
    private final Connection con;
    private final int contractId;
    private List<ContractParameterGroupAttr> prefs;
    private BalanceUtils bu;
    private ContractManager contractManager;
    private Contract contract;

    public List<ContractParameterGroupAttr> getContractParameterPrefs() {
        if (this.prefs == null) {
            try (ContractParameterGroupAttrDao dao = new ContractParameterGroupAttrDao(this.con);){
                this.prefs = dao.list();
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
        return this.prefs;
    }

    public BalanceUtils getBalanceUtils() {
        if (this.bu == null) {
            this.bu = new BalanceUtils(this.con);
        }
        return this.bu;
    }

    public ContractManager getContractManager1() {
        if (this.contractManager == null) {
            this.contractManager = new ContractManager(this.con);
        }
        return this.contractManager;
    }

    public Contract getContract(int contractId) throws BGException {
        if (this.contract == null || this.contract.getId() != contractId) {
            this.contract = ContractDao.getContract((Connection)this.con, (int)contractId);
        }
        return this.contract;
    }

    public BGMacrosFormat(Connection con, int mid, int cid) {
        this.con = con;
        this.contractId = cid;
    }

    public BGMacrosFormat(Connection con, int mid, Contract contract) {
        this.con = con;
        this.contractId = contract.getId();
        this.contract = contract;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invoke(String macros, Object[] args) throws BGException {
        if ("contract_param".equals(macros)) {
            if (args.length <= 0) return null;
            int pid = this.getInt(args, 0, 0);
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                ContractParameterGroupAttr pref;
                Iterator<ContractParameterGroupAttr> iterator = this.getContractParameterPrefs().iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while ((pref = iterator.next()).getId() != pid);
                switch (pref.getType()) {
                    case 1: {
                        String string = contractDao.optContractParameterTextAsString(this.contractId, pid).orElse("");
                        return string;
                    }
                    case 8: {
                        String string = contractDao.getContractParameterAddressAsString(this.contractId, pid).orElse("");
                        return string;
                    }
                }
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        if ("contract_balance".equals(macros)) {
            return this.getBalanceUtils().getBalance(LocalDate.now(), this.contractId);
        }
        if ("contract_title".equals(macros)) {
            Contract contract = this.getContract(this.contractId);
            if (contract == null) return null;
            String string = contract.getTitle();
            return string;
        }
        if (!"contract_comment".equals(macros)) return null;
        Contract contract = this.getContract(this.contractId);
        if (contract == null) return "";
        String string = contract.getComment();
        return string;
    }
}

