/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractFace;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.events.MPSBeforePaymentEvent;
import ru.bitel.bgbilling.modules.mps.server.events.MPSBeforeRequestEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

abstract class OSMPAbstractTransactionManager
extends MPSTransactionManager {
    protected static final String TIMEPATTERN = "yyyyMMddHHmmss";
    protected String nameCommand;
    protected String nameAccount;
    protected String nameTxnID;
    protected String nameTxnDate;
    protected String resultTxnID;
    protected String resultPrvTxnID;
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^(\\d+)\\t([\\d+\\.:\\t]+)\\t(.+)\\t(\\d+\\.*\\d*)$", 8);

    OSMPAbstractTransactionManager() {
        this(null, null, null, null, null, null);
    }

    OSMPAbstractTransactionManager(String nameCommand, String nameAccount, String nameTxnID, String nameTxnDate, String resultTxnID, String resultPrvTxnID) {
        this.nameCommand = nameCommand != null ? nameCommand : "command";
        this.nameAccount = nameAccount != null ? nameAccount : "account";
        this.nameTxnID = nameTxnID != null ? nameTxnID : "txn_id";
        this.nameTxnDate = nameTxnDate != null ? nameTxnDate : "txn_date";
        this.resultTxnID = resultTxnID != null ? resultTxnID : "osmp_txn_id";
        this.resultPrvTxnID = resultPrvTxnID != null ? resultPrvTxnID : "prv_txn";
    }

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            mpsResponse.getParameters().put("request", mpsRequest);
            this.checkValid(system, mpsRequest, con);
            MPSBeforeRequestEvent beforeRequestEvent = new MPSBeforeRequestEvent(moduleId, mpsRequest, mpsResponse);
            beforeRequestEvent = (MPSBeforeRequestEvent)EventProcessor.getInstance().request((QueueEvent)beforeRequestEvent);
            if (beforeRequestEvent.getParameters() != null && beforeRequestEvent.getParameters().size() > 0) {
                mpsResponse.getParameters().put("response_parameters", beforeRequestEvent.getParameters());
            }
            if (beforeRequestEvent.isProcessed()) {
                return this.getResponse(con, system, mpsResponse);
            }
            switch (mpsRequest.getAction()) {
                case 1: {
                    if (mpsRequest.getSum().compareTo(system.minSumm) >= 0 && mpsRequest.getSum().compareTo(system.maxSumm) <= 0) {
                        Contract contract = this.actionCheck(mpsRequest);
                        mpsResponse.setContract(contract);
                        mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                        break;
                    }
                    throw new MPSException(8, "\u0412\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 " + String.valueOf(system.minSumm) + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431.;") + " \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 - " + String.valueOf(system.maxSumm) + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
                }
                case 2: 
                case 10: {
                    Transaction transaction;
                    Transaction transaction2 = transaction = system.extDontCheckTransId ? null : this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(300);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0435\u0441\u0442\u044c \u0432 \u0431\u0430\u0437\u0435, \u043d\u043e \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                        break;
                    }
                    if (transaction == null) {
                        Contract contract = this.actionCheck(mpsRequest);
                        this.checkTime(mpsRequest);
                        MPSBeforePaymentEvent beforePaymentEvent = new MPSBeforePaymentEvent(moduleId, mpsRequest.getSum(), system.paymentType);
                        beforePaymentEvent = (MPSBeforePaymentEvent)EventProcessor.getInstance().request((QueueEvent)beforePaymentEvent);
                        BigDecimal scriptSum = beforePaymentEvent.getPaymentSum();
                        system.paymentType = beforePaymentEvent.getPaymentType();
                        transaction = this.addTransaction(-1, con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), scriptSum, mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                        mpsResponse.setContract(contract);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    } else {
                        Contract contract = this.getContractById(con, transaction.getContractId());
                        mpsResponse.setContract(contract);
                        if (contract != null) {
                            mpsResponse.setResult(system.config.getInt("resultCodeOnDublicatePayment", 0));
                            mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                        }
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setSum(transaction.getSum());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    break;
                }
                case 4: {
                    String cancelTransId = request.getParameter("cancel_txn_id");
                    Date cancelTime = TimeUtils.parseDate((String)request.getParameter("cancel_txn_date"), (String)TIMEPATTERN);
                    if (cancelTransId != null && cancelTime != null) {
                        Transaction transaction;
                        mpsResponse.setId(System.currentTimeMillis());
                        mpsResponse.getParameters().put("cancel_txn_id", cancelTransId);
                        Transaction transaction3 = transaction = system.extDontCheckTransId ? null : this.getTransactionByTransId(con, moduleId, mpsId, cancelTransId, cancelTime);
                        if (transaction != null) {
                            this.cancelTransaction(con, moduleId, mpsId, system, transaction);
                            break;
                        }
                        mpsResponse.setResult(300);
                        mpsResponse.setMessage("\u041e\u0442\u043c\u0435\u043d\u044f\u0435\u043c\u0430\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0411\u0414 [cancel_trans_id=" + cancelTransId + "]");
                        break;
                    }
                    mpsResponse.setResult(300);
                    mpsResponse.setMessage("\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b [cancel_txn_id \u0438/\u0438\u043b\u0438 cancel_txn_date)");
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element responseElement = XMLUtils.createElement((Document)doc, (String)"response");
        this.processResponseEvent(response, responseElement);
        XMLUtils.createElement((Element)responseElement, (String)"result").setTextContent(String.valueOf(response.getResult()));
        if (response.getTransId() != null) {
            XMLUtils.createElement((Element)responseElement, (String)this.resultTxnID).setTextContent(response.getTransId());
        }
        if (response.getAction() == 4) {
            XMLUtils.createElement((Element)responseElement, (String)"cancel_txn_id").setTextContent(String.valueOf(response.getParameters().get("cancel_txn_id")));
        }
        if (response.getAction() == 2 || response.getAction() == 4) {
            XMLUtils.createElement((Element)responseElement, (String)this.resultPrvTxnID).setTextContent(String.valueOf(response.getId()));
            XMLUtils.createElement((Element)responseElement, (String)"sum").setTextContent(Utils.formatCost((BigDecimal)response.getSum()));
        }
        if (response.getMessage() != null) {
            XMLUtils.createElement((Element)responseElement, (String)"comment").setTextContent(response.getMessage());
        }
        if (system.extAddBalanceInfo && response.getContract() != null && response.getTransId() != null) {
            void var7_11;
            BalanceUtils balanceUtils = new BalanceUtils(con);
            BigDecimal bigDecimal = balanceUtils.getBalance(LocalDate.now(), response.getContract().getId());
            if (system.extOSMPSubBalance) {
                BigDecimal subDebt = BigDecimal.ZERO;
                Pattern pattern = Pattern.compile(system.osmpContractPattern);
                try (ContractDao contractDao = new ContractDao(con, 0);){
                    for (Contract sub : contractDao.getSubContracts(response.getContract().getId(), 1)) {
                        Matcher matcher = pattern.matcher(sub.getTitle());
                        if (!matcher.matches()) continue;
                        BigDecimal subBalance = balanceUtils.getBalanceOut(new Date(), sub.getId());
                        if (response.getContract().getFace() == ContractFace.FIZIC) {
                            subDebt = subDebt.add(subBalance);
                            continue;
                        }
                        if (subBalance.compareTo(BigDecimal.ZERO) >= 0) continue;
                        subDebt = subDebt.add(subBalance);
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
                if (response.getContract().getFace() == ContractFace.FIZIC) {
                    BigDecimal bigDecimal2 = bigDecimal.add(subDebt);
                } else if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                    BigDecimal bigDecimal3 = bigDecimal.add(subDebt);
                } else {
                    BigDecimal bigDecimal4 = subDebt;
                }
            }
            XMLUtils.createElement((Element)responseElement, (String)"account_balance").setTextContent(Utils.formatCost((BigDecimal)var7_11));
            balanceUtils.close();
        }
        for (Map.Entry entry : this.getResponseAttributes(con, system, response).entrySet()) {
            XMLUtils.createElement((Element)responseElement, (String)((String)entry.getKey())).setTextContent((String)entry.getValue());
        }
        if (system.extOSMPFields && response.getParameters().containsKey("fields")) {
            Element fieldsElement = XMLUtils.createElement((Element)responseElement, (String)"fields");
            String string = response.getParameters().get("fields").toString();
            String[] fieldDataArray = string.split(";");
            for (int i = 1; i <= fieldDataArray.length; ++i) {
                String[] fieldItemArray = fieldDataArray[i - 1].split(":");
                String fieldName = null;
                String fieldType = "disp";
                String fieldValue = null;
                if (fieldItemArray.length == 3) {
                    fieldName = fieldItemArray[0];
                    fieldType = Utils.isBlankString((String)fieldItemArray[1]) ? "disp" : fieldItemArray[1];
                    fieldValue = fieldItemArray[2];
                } else if (fieldItemArray.length == 2) {
                    fieldName = fieldItemArray[0];
                    fieldValue = fieldItemArray[1];
                }
                Element fieldElement = XMLUtils.createElement((Element)fieldsElement, (String)("field" + i));
                fieldElement.setTextContent(fieldValue);
                fieldElement.setAttribute("name", fieldName);
                fieldElement.setAttribute("type", fieldType);
            }
        }
        this.setResponseParameters(response, responseElement);
        return this.xmlSerialize(doc);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) {
        char type;
        MPSRequest req = new MPSRequest(con, moduleId, mpsId, request, system);
        String actionString = request.getParameter(this.nameCommand);
        if ("check".equals(actionString)) {
            req.setAction(1);
        } else if ("pay".equals(actionString)) {
            req.setAction(2);
        } else if ("cancel".equals(actionString)) {
            req.setAction(4);
        }
        req.setRawNumber(request.getParameter(this.nameAccount));
        if (system.osmpPrefix && req.getRawNumber() != null && req.getRawNumber().length() > 1 && req.getRawNumber().charAt(1) == '_' && Character.isDigit((int)(type = req.getRawNumber().charAt(0)))) {
            req.setType(Character.getNumericValue((int)type));
            req.setNumber(req.getRawNumber().substring(2));
        } else {
            req.setNumber(req.getRawNumber());
            req.setType(Utils.parseInt((String)request.getParameter("pay_type"), (int)0));
        }
        String sum = request.getParameter("sum");
        req.setSum(Utils.parseBigDecimal((String)(sum != null ? sum.replace(',', '.') : "0"), (BigDecimal)BigDecimal.ZERO));
        req.setTransId(request.getParameter(this.nameTxnID));
        req.setTime(TimeUtils.parseDate((String)request.getParameter(this.nameTxnDate), (String)TIMEPATTERN));
        return req;
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest req, Connection con) throws MPSException {
        switch (req.getAction()) {
            case 1: {
                if (req.getNumber() == null || req.getNumber().length() <= 0 || req.getSum() == null || !system.extDontCheckSum && req.getSum().compareTo(BigDecimal.ZERO) <= 0 || req.getTransId() == null || this.parseBigInteger(req.getTransId()).compareTo(BigInteger.ZERO) <= 0) {
                    throw new MPSException(2);
                }
                if (system.numberPattern == null || system.numberPattern.matcher(req.getNumber()).matches()) break;
                throw new MPSException(13);
            }
            case 2: {
                if (req.getNumber() == null || req.getNumber().length() <= 0 || req.getSum() == null || !system.extDontCheckSum && req.getSum().compareTo(BigDecimal.ZERO) <= 0 || req.getTransId() == null || this.parseBigInteger(req.getTransId()).compareTo(BigInteger.ZERO) <= 0 || req.getTime() == null) {
                    throw new MPSException(2);
                }
                if (system.numberPattern == null || system.numberPattern.matcher(req.getNumber()).matches()) break;
                throw new MPSException(13);
            }
        }
        super.checkValid(system, req, con);
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(300);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(5);
                response.setMessage(ex.message);
                break;
            }
            case 6: {
                response.setResult(300);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(242);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case -1: {
                response.setResult(300);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(300);
                response.setMessage(ex.message);
                break;
            }
            case 4: {
                response.setResult(300);
                response.setMessage(ex.message);
                break;
            }
            case 13: {
                response.setResult(4);
                response.setMessage(ex.message);
                break;
            }
            case 20: {
                response.setResult(7);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Matcher match = this.getFilePattern().matcher(file);
        while (match.find()) {
            char type;
            String number = match.group(3);
            Transaction transaction = new Transaction().setTransId(Utils.parseLong((String)match.group(1), (long)0L)).setTime(TimeUtils.parseDate((String)match.group(2), (String)this.getFileTimePattern())).setRawNumber(number).setSum(Utils.parseBigDecimal((String)match.group(4).replaceAll(",", "."), (BigDecimal)BigDecimal.ZERO)).setStatus(TransactionStatus.PAYMENT_PAYED.getCode());
            if (system.osmpPrefix && number != null && number.length() > 1 && number.charAt(1) == '_' && Character.isDigit((int)(type = number.charAt(0)))) {
                transaction.setType(Character.getNumericValue((int)type));
                transaction.setNumber(number.substring(2));
            } else {
                transaction.setNumber(number);
            }
            result.add(transaction);
        }
        return result;
    }

    protected Pattern getFilePattern() {
        return TRANSACTION_PATTERN;
    }

    protected String getFileTimePattern() {
        return "dd.MM.yyyy\tHH:mm:ss";
    }

    public class ErrorCode {
        public static final int ANSWER_SUCCESS = 0;
        public static final int ANSWER_TEMPORALY_ERROR = 1;
        public static final int ANSWER_ERR_CONTRACT_ID = 4;
        public static final int ANSWER_ERR_CONTRACT_NOT_FOUND = 5;
        public static final int ANSWER_ERR_RESTRICT = 7;
        public static final int ANSWER_ERR_OFF = 8;
        public static final int ANSWER_ERR_CONTRACT_NOT_ACTIVE = 79;
        public static final int ANSWER_ERR_SUMM_TOOSMALL = 241;
        public static final int ANSWER_ERR_SUMM_TOOBIG = 242;
        public static final int ANSWER_ERR_PAYMENT_DONT_KNOWN = 243;
        public static final int ANSWER_ERR_UNKNOWN = 300;

        public ErrorCode(OSMPAbstractTransactionManager this$0) {
        }
    }
}

