/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree.voice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.voice.RangeList;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class VoiceTariffConfigTreeNode
extends DefaultTariffTreeNode {
    private JPanel editor;
    private RangeList roundList = new RangeList();
    private JCheckBox useRound = new JCheckBox();
    private JCheckBox useForAuth = new JCheckBox();
    private JLabel view = new JLabel(this.getLabelText());
    private BGIntTextField scale = new BGIntTextField(7);
    private BGIntTextField freeLimit = new BGIntTextField(7);

    public VoiceTariffConfigTreeNode() {
        this.view.setIcon(ClientUtils.getIcon((String)"config"));
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected String getLabelText() {
        return "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438";
    }

    @Override
    protected void loadData() {
        String data = this.getData();
        String[] parts = data.split(";");
        if (parts.length >= 3) {
            this.useForAuth.setSelected(parts[0].equals("1"));
            this.freeLimit.setText(parts[1]);
            this.roundList.setData(parts[2]);
            if (parts.length > 3) {
                this.scale.setText(parts[3]);
            }
            if (parts.length > 4) {
                this.useRound.setSelected(parts[4].equals("1"));
            }
        } else {
            this.useRound.setSelected(false);
            this.useForAuth.setSelected(false);
            this.freeLimit.setText("0");
            this.scale.setText("");
            this.roundList.setData("");
        }
    }

    @Override
    protected void serializeData() {
        StringBuffer result = new StringBuffer(300);
        result.append(this.useForAuth.isSelected() ? "1" : "0");
        result.append(";");
        result.append(this.freeLimit.getText());
        result.append(";");
        result.append(this.roundList.getData());
        result.append(";");
        result.append(this.scale.getText());
        result.append(";");
        result.append(this.useRound.isSelected() ? "1" : "0");
        this.setData(result.toString());
    }

    @Override
    public Component getEditor() {
        if (this.editor == null) {
            this.loadData();
            this.createEditorPanel();
        }
        return this.editor;
    }

    private void createEditorPanel() {
        int gridy = 0;
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u0411\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u044b\u0439 \u043f\u043e\u0440\u043e\u0433:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.freeLimit, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u041e\u043a\u0440\u0443\u0433\u043b\u044f\u0442\u044c \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0434\u043e \u0437\u043d\u0430\u043a\u0430:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.scale, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u0423\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438:"), new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.useForAuth, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u0417\u0430\u043c\u0435\u043d\u044f\u0442\u044c \u0434\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043d\u0430 \u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0443\u044e:"), new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.useRound, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> {
            String command = e.getActionCommand();
            if (command.equals("ok")) {
                this.serializeData();
                this.saveData();
            }
            this.tree.getViewableTree().stopEditing();
            this.tree.updateTree();
        });
        this.editor = new JPanel(new GridBagLayout());
        this.editor.setMinimumSize(new Dimension(400, 300));
        this.editor.setPreferredSize(new Dimension(400, 300));
        this.editor.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.editor.add((Component)this.roundList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    protected JPanel getEditorPanel() {
        return (JPanel)this.getEditor();
    }

    @Override
    public void serializeToXML(Element element) throws Exception {
        super.serializeToXML(element);
        element.setAttribute("data", this.getData());
        this.serializeChildsToXML(element);
    }

    @Override
    public void loadFromXML(Element element) throws Exception {
        String data = element.getAttribute("data");
        if (data.length() > 0) {
            this.setData(String.valueOf(data));
            this.saveData();
        }
        this.loadChildsFromXML(element);
    }
}

