/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionType;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class MegafonOptionDao
extends AbstractIdDao<MegafonOption> {
    public MegafonOptionDao(Connection con, int moduleId) {
        super(con, "megafon_option", moduleId);
    }

    public List<MegafonOption> list(String filter, String orderBy, Object ... params) throws SQLException {
        return super.list(filter, orderBy, params);
    }

    protected MegafonOption getFromRS(ResultSet rs) throws SQLException {
        MegafonOption option = new MegafonOption();
        option.setId(rs.getInt("id"));
        option.setTitle(rs.getString("title"));
        option.setOptionType((MegafonOptionType)MegafonOptionType.getType((int)rs.getInt("option_type")).orElse(null));
        option.setProductOfferingId(rs.getString("uuid"));
        option.setNpayServiceId(rs.getInt("npay_service_id"));
        option.setPrice(rs.getBigDecimal("price"));
        return option;
    }

    protected void updateImpl(MegafonOption option) throws SQLException {
        try (PreparedStatement ps = this.prepareStatement((Idable)option, "title=?, uuid=?, option_type=?, npay_service_id=?, price=?");){
            int index = 1;
            ps.setString(index++, option.getTitle());
            ps.setString(index++, option.getProductOfferingId());
            ps.setInt(index++, option.getOptionType() != null ? option.getOptionType().ordinal() : MegafonOptionType.ONE_TIME.ordinal());
            ps.setInt(index++, option.getNpayServiceId());
            ps.setBigDecimal(index++, option.getPrice());
            this.executeUpdate((Id)option, index, ps);
        }
    }
}

