/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.common.bean;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.text.DecimalFormat;
import java.util.Date;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.ListItem;
import ru.bitel.common.xml.JAXBUtils;

public class UserCard
extends Id
implements GuiTitlable,
ListItem {
    private static final DecimalFormat CARD_FORMAT = new DecimalFormat("000000");
    public static final UserCard NULL = new UserCard();
    protected int contractId;
    protected long number;
    protected Date date1;
    protected Date date2;
    protected Date subscrDate;
    protected String comment;
    protected int basecardId;
    protected String basecardTitle;
    protected int slavecardsNumber;
    private int objectId;
    private int userdeviceId;
    private String userdeviceSN;
    private boolean needSync;
    private String contractTitleComment;
    private String pairingModule;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof UserCard) {
            UserCard uc = (UserCard)((Object)obj);
            return uc.id == this.id && uc.number == this.number && (Utils.isBlankString((String)uc.comment) && Utils.isBlankString((String)this.comment) || uc.comment.equals(this.comment)) && uc.contractId == this.contractId && TimeUtils.dateEqual((Date)uc.date1, (Date)this.date1) && TimeUtils.dateEqual((Date)uc.date2, (Date)this.date2) && TimeUtils.dateEqual((Date)uc.subscrDate, (Date)this.subscrDate);
        }
        return false;
    }

    public String format() {
        return CARD_FORMAT.format(this.number);
    }

    public int getBasecardId() {
        return this.basecardId;
    }

    public String getBasecardTitle() {
        return this.basecardTitle;
    }

    public String getComment() {
        return this.comment;
    }

    public int getContractId() {
        return this.contractId;
    }

    public String getContractTitleComment() {
        return this.contractTitleComment;
    }

    @XmlJavaTypeAdapter(value=JAXBUtils.DateAdapter.class)
    public Date getDate1() {
        return this.date1;
    }

    @XmlJavaTypeAdapter(value=JAXBUtils.DateAdapter.class)
    public Date getDate2() {
        return this.date2;
    }

    public String getGuiTitle() {
        return "\u041a\u0430\u0440\u0442\u0430 " + this.format() + " (" + TimeUtils.formatPeriod((Date)this.date1, (Date)this.date2) + ")";
    }

    public long getNumber() {
        return this.number;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public String getPairingModule() {
        return this.pairingModule;
    }

    public int getSlavecardsNumber() {
        return this.slavecardsNumber;
    }

    public Date getSubscrDate() {
        return this.subscrDate;
    }

    public String getTitle() {
        return this.getGuiTitle();
    }

    public int getUserdeviceId() {
        return this.userdeviceId;
    }

    public String getUserdeviceSN() {
        return this.userdeviceSN;
    }

    public boolean isNeedSync() {
        return this.needSync;
    }

    public UserCard setBasecardId(int basecardId) {
        this.basecardId = basecardId;
        return this;
    }

    public UserCard setBasecardTitle(String basecardTitle) {
        this.basecardTitle = basecardTitle;
        return this;
    }

    public UserCard setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public UserCard setContractId(int contractId) {
        this.contractId = contractId;
        return this;
    }

    public UserCard setContractTitleComment(String contractTitleComment) {
        this.contractTitleComment = contractTitleComment;
        return this;
    }

    public UserCard setDate1(Date date1) {
        this.date1 = date1;
        return this;
    }

    public UserCard setDate2(Date date2) {
        this.date2 = date2;
        return this;
    }

    public UserCard setId(int id) {
        super.setId(id);
        return this;
    }

    public UserCard setNeedSync(boolean needSync) {
        this.needSync = needSync;
        return this;
    }

    public UserCard setNumber(long number) {
        this.number = number;
        return this;
    }

    public UserCard setObjectId(int objectId) {
        this.objectId = objectId;
        return this;
    }

    public UserCard setPairingModule(String pairingModule) {
        this.pairingModule = pairingModule;
        return this;
    }

    public UserCard setSlavecardsNumber(int slavecardsNumber) {
        this.slavecardsNumber = slavecardsNumber;
        return this;
    }

    public UserCard setSubscrDate(Date changeSubscrDate) {
        this.subscrDate = changeSubscrDate;
        return this;
    }

    public UserCard setUserdeviceId(int userdeviceId) {
        this.userdeviceId = userdeviceId;
        return this;
    }

    public UserCard setUserdeviceSN(String userdeviceSN) {
        this.userdeviceSN = userdeviceSN;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30).append("\u041a\u0430\u0440\u0442\u0430: \u043a\u043e\u0434 = ").append(this.id).append(", \u043d\u043e\u043c\u0435\u0440 = ").append(this.number).append(", \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 = ").append(this.contractId).append(", \u0434\u0430\u0442\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f = ").append(TimeUtils.formatDate((Date)this.date1)).append(", \u0434\u0430\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f = ").append(TimeUtils.formatDate((Date)this.date2)).append(", \u0434\u0430\u0442\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 = ").append(TimeUtils.formatDate((Date)this.subscrDate)).append(", \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 = ").append(this.comment);
        if (this.basecardId > 0) {
            sb.append(", \u043c\u0443\u043b\u044c\u0442\u0438\u0440\u0443\u043c-\u043a\u043e\u043f\u0438\u044f-\u0434\u043b\u044f = ").append(this.basecardId);
        }
        return sb.toString();
    }
}

