/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.simplepay.server.bean;

import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.modules.simplepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.simplepay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, "simplepay_transaction", moduleId);
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true").append(this.queryPeriod(period, "pt.create_date"));
            if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                query.append(" AND pt.result=?");
            }
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND c.title LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND c.id=").append(contractId);
            }
            try {
                PreparedStatement ps = null;
                ps = this.con.prepareStatement("SELECT pt.*, c.title AS contract_title" + query.toString() + this.getSQLOrder(sort, this.fields) + Page.toSqlLimit((Page)page));
                int index = this.psSetPeriod(ps, 1, period);
                if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
                ps.close();
                ps = this.con.prepareStatement("SELECT SUM(pt.sum), COUNT(*) " + query.toString());
                index = this.psSetPeriod(ps, 1, period);
                if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                this.executeQuerySumPage(ps, searchResult);
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void doCheckRequest(int transactionId) throws Exception {
        Transaction transaction = (Transaction)this.get(transactionId);
        if (transaction == null) {
            throw new BGException("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430: #ID " + transactionId);
        }
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("sp_salt", Utils.getDigest((String)String.valueOf(System.currentTimeMillis()), (String)"UTF-8"));
        dataMap.put("sp_merchant_id", moduleSetup.get("simplepay.merchant.id", ""));
        dataMap.put("sp_outlet_id", moduleSetup.get("simplepay.outlet.id", ""));
        dataMap.put("sp_order_id", String.valueOf(transactionId));
        String scriptName = moduleSetup.get("simplepay.url.get.status", "https://api.simplepay.pro/sp/get_status");
        String[] keys = new String[]{"sp_salt", "sp_merchant_id", "sp_outlet_id", "sp_order_id"};
        String secretKey = moduleSetup.get("simplepay.merchant.secret.key", moduleSetup.get("simplepay.secret.key", ""));
        dataMap.put("sp_sig", TransactionManager.getSign(scriptName, keys, dataMap, secretKey));
        StringBuilder spec = new StringBuilder().append(moduleSetup.get("simplepay.url.get.status", "https://api.simplepay.pro/sp/get_status")).append("?").append("sp_salt").append("=").append(dataMap.get("sp_salt")).append("&").append("sp_merchant_id").append("=").append(dataMap.get("sp_merchant_id")).append("&").append("sp_outlet_id").append("=").append(dataMap.get("sp_outlet_id")).append("&").append("sp_order_id").append("=").append(transactionId).append("&").append("sp_sig").append("=").append(dataMap.get("sp_sig"));
        String resultXml = "";
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(spec.toString())).GET().build();
            resultXml = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: " + resultXml);
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
        Document doc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(resultXml)));
        String status = XMLUtils.selectText((Node)doc, (String)"/response/sp_status/text()");
        String salt = XMLUtils.selectText((Node)doc, (String)"/response/sp_salt/text()");
        String sig = XMLUtils.selectText((Node)doc, (String)"/response/sp_sig/text()");
        StringBuilder params = new StringBuilder().append("sp_status").append("=").append(status).append("\n").append("sp_salt").append("=").append(salt).append("\n").append("sp_sig").append("=").append(sig);
        if ("ok".equals(status)) {
            String paymentId = XMLUtils.selectText((Node)doc, (String)"/response/sp_payment_id/text()");
            String transactionStatus = XMLUtils.selectText((Node)doc, (String)"/response/sp_transaction_status/text()");
            String paymentSystem = XMLUtils.selectText((Node)doc, (String)"/response/sp_payment_system/text()");
            if ("ok".equals(transactionStatus)) {
                transaction.setStatus(TransactionStatus.OK.getCode());
                if (transaction.getPaymentId() < 1) {
                    Date paymentDate = transaction.getTransactionDate();
                    if (paymentDate == null) {
                        paymentDate = new Date();
                        transaction.setTransactionDate(paymentDate);
                    }
                    Payment payment = new Payment().setDate(paymentDate).setTypeId(moduleSetup.getInt("simplepay.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("simplepay.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0440\u0432\u0438\u0441 SimplePay [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
                    new PaymentDao(this.con).update((Object)payment);
                    transaction.setPaymentId(payment.getId());
                }
            } else if ("failed".equals(transactionStatus)) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                params.append("\n").append("sp_failure_code").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_failure_code/text()", (String)""));
                params.append("\n").append("sp_failure_description").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_failure_description/text()", (String)""));
            } else if ("revoked".equals(transactionStatus)) {
                params.append("\n").append("sp_failure_code").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_failure_code/text()", (String)""));
                params.append("\n").append("sp_failure_description").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_failure_description/text()", (String)""));
            }
            params.append("\n").append("sp_payment_id").append("=").append(paymentId).append("\n").append("sp_transaction_status").append("=").append(transactionStatus).append("\n").append("sp_payment_system").append("=").append(paymentSystem).append("\n").append("sp_overpayment").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_overpayment/text()", (String)"")).append("\n").append("sp_can_reject").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_can_reject/text()", (String)"")).append("\n").append("sp_create_date").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_create_date/text()", (String)"")).append("\n").append("sp_result_date").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_result_date/text()", (String)"")).append("\n").append("sp_card_brand").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_card_brand/text()", (String)"")).append("\n").append("sp_card_pan").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_card_pan/text()", (String)"")).append("\n").append("sp_auth_code").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_auth_code/text()", (String)""));
        } else if ("error".equals(status)) {
            params.append("\nsp_error_description").append("=").append(XMLUtils.selectText((Node)doc, (String)"/response/sp_error_description/text()"));
        }
        transaction.setParameters(params.toString());
        this.update(transaction);
    }

    protected String getQueryById() {
        return "SELECT t.*, c.title AS contract_title FROM " + this.tableName + " AS t LEFT JOIN contract c ON c.id=t.contract_id WHERE t.id=?";
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setTransactionId(rs.getString("transaction_id"))).setStatus(rs.getString("result"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).build();
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, result=?, params=?, sum=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public static String getSign(String scriptName, String[] keys, Map<String, Object> dataMap, String secretKey) {
        StringBuffer signData = new StringBuffer(scriptName.substring(scriptName.lastIndexOf("/") + 1)).append(";");
        List<String> sortedKeys = Arrays.asList(keys);
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            signData.append(dataMap.get(key)).append(";");
        }
        signData.append(secretKey);
        String sign = Utils.getDigest((String)signData.toString(), (String)"UTF-8").toLowerCase();
        if (LogManager.getLogger().isDebugEnabled()) {
            for (String key : sortedKeys) {
                LogManager.getLogger().debug(key + ": " + String.valueOf(dataMap.get(key)));
            }
            LogManager.getLogger().debug("secretKey: " + secretKey);
            LogManager.getLogger().debug("signData: " + String.valueOf(signData));
            LogManager.getLogger().debug("sp_sig: " + sign);
        }
        return sign;
    }
}

