/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client.tariff;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class AmountRangeTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"period");
    private JLabel view;
    private BGIntTextField fromTf;
    private BGIntTextField toTf;
    private BGComboBox<IdTitle> amountCombo;
    private BGComboBox<ComboBoxItem> typeCombo;
    private int amount;
    private String from;
    private String to;
    private int type;
    private Directory dir;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.dir = this.getDirManager().getDirectory("module_amounts");
    }

    private void initEdit() throws Exception {
        if (this.typeCombo == null) {
            this.typeCombo = new BGComboBox();
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"0", "\u0431\u0430\u0439\u0442"));
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"1", "KB"));
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"2", "MB"));
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"3", "GB"));
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"4", "\u0441\u0435\u043a\u0443\u043d\u0434"));
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"5", "\u043c\u0438\u043d\u0443\u0442"));
            this.typeCombo.addItem((Object)new ComboBoxItem((Object)"6", "\u0447\u0430\u0441\u043e\u0432"));
            this.amountCombo = new BGComboBox(this.dir.getItems());
            this.fromTf = new BGIntTextField();
            this.toTf = new BGIntTextField();
        }
    }

    protected JPanel getEditorPanel() throws Exception {
        this.initEdit();
        JPanel edit = new JPanel();
        edit.add(new JLabel("\u0415\u0441\u043b\u0438 "));
        edit.add((Component)this.amountCombo);
        edit.add(new JLabel(" \u043e\u0442 "));
        edit.add((Component)this.fromTf);
        edit.add(new JLabel(" \u0434\u043e "));
        edit.add((Component)this.toTf);
        edit.add((Component)this.typeCombo);
        return edit;
    }

    public Component getView() throws Exception {
        this.extractData();
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        StringBuffer title = new StringBuffer(150);
        title.append("\u0415\u0441\u043b\u0438 ");
        String amountTitle = this.dir.getValue(this.amount);
        title.append(amountTitle);
        title.append(" \u043e\u0442 ");
        title.append(this.from);
        title.append(" \u0434\u043e ");
        title.append(this.to);
        title.append(" ");
        title.append(this.getUnitName(this.type));
        this.view.setText(title.toString());
        return this.view;
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.amount = Utils.parseInt((String)((String)data.get("amount")), (int)0);
        this.from = (String)data.get("from");
        this.to = (String)data.get("to");
        this.type = Utils.parseInt((String)((String)data.get("type")), (int)-1);
    }

    protected void loadData() {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox)this.amountCombo, this.amount);
        ClientUtils.setComboBoxSelection(this.typeCombo, (Object)String.valueOf(this.type));
        this.fromTf.setText(this.from);
        this.toTf.setText(this.to);
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("from", this.fromTf.getText());
        data.put("to", this.toTf.getText());
        data.put("amount", String.valueOf(this.getIdFromDirectoryCombo((JComboBox)this.amountCombo)));
        data.put("type", ClientUtils.getIdFromComboBox(this.typeCombo));
        this.setDataInHash(data);
    }
}

