/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.table.renderer.BooleanTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RoleItem;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.TreeNode;

public class RoleTreeTablePanel
extends JPanel {
    private final RoleTreeTableModel treeTableModel;
    private final BGUTreeTable rolesTree;
    private RoleItem rootNode = new RoleItem();
    private final boolean isCheckedTree;
    private final boolean isShowMenu;

    public RoleTreeTablePanel(final boolean isCheckedTree, boolean isShowMenu) {
        this.isShowMenu = isShowMenu;
        this.isCheckedTree = isCheckedTree;
        this.treeTableModel = new RoleTreeTableModel();
        this.rolesTree = new BGUTreeTable((BGTreeTableModel)this.treeTableModel);
        this.rolesTree.setSelectionMode(0);
        this.rolesTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column = RoleTreeTablePanel.this.rolesTree.columnAtPoint(e.getPoint());
                if (isCheckedTree && e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e) && column == 1) {
                    JCheckBox checkBox = (JCheckBox)((Object)RoleTreeTablePanel.this.rolesTree.getCellRenderer(RoleTreeTablePanel.this.rolesTree.getSelectedRow(), 1));
                    RoleItem selectedRole = (RoleItem)((Object)RoleTreeTablePanel.this.treeTableModel.getSelectedRow());
                    if (RoleTreeTablePanel.this.treeTableModel.selectedRoles.contains((Object)selectedRole)) {
                        RoleTreeTablePanel.this.treeTableModel.selectedRoles.remove((Object)selectedRole);
                        checkBox.setSelected(false);
                    } else {
                        RoleTreeTablePanel.this.treeTableModel.selectedRoles.add(selectedRole);
                        checkBox.setSelected(true);
                    }
                    RoleTreeTablePanel.this.rolesTree.revalidate();
                    RoleTreeTablePanel.this.rolesTree.repaint();
                }
            }
        });
        if (isCheckedTree) {
            JTree tree = (JTree)((Object)this.rolesTree.getDefaultRenderer(TreeNode.class));
            tree.setCellRenderer(new CheckedTreeCellRenderer());
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane((Component)this.rolesTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u0420\u043e\u043b\u0438");
    }

    public RoleTreeTablePanel() {
        this(false, true);
    }

    public void setRoles(List<RoleItem> roles) {
        this.rootNode.setChildren(roles);
        this.setData(this.rootNode);
    }

    public List<RoleItem> getRoles() {
        return this.rootNode.getChildren();
    }

    public List<Integer> getRolesIds() {
        return this.getRoles().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList());
    }

    public BGUTreeTable getTree() {
        return this.rolesTree;
    }

    public void setData(RoleItem role) {
        this.treeTableModel.setData((Object)role);
    }

    public Optional<RoleItem> getSelectedRole() {
        if (this.treeTableModel != null) {
            return Optional.ofNullable((RoleItem)((Object)this.treeTableModel.getSelectedRow()));
        }
        return Optional.empty();
    }

    public List<RoleItem> getCheckedRoles() {
        return Optional.ofNullable(this.treeTableModel).map(tableModel -> tableModel.selectedRoles).orElse(new ArrayList());
    }

    public List<Integer> getCheckedRoleIds() {
        return this.getCheckedRoles().stream().mapToInt(Id::getId).boxed().toList();
    }

    public void setCheckedRoles(Set<Integer> roleIds) {
        this.setCheckedRoles(new ArrayList<Integer>(roleIds));
    }

    public void setCheckedRoles(List<Integer> roleIds) {
        this.treeTableModel.selectedRoles.clear();
        if (Utils.notEmptyCollection(roleIds)) {
            this.treeTableModel.selectedRoles.addAll(this.rootNode.getChildren().stream().filter(role -> roleIds.contains(role.getId())).toList());
        }
        this.rolesTree.revalidate();
        this.rolesTree.repaint();
    }

    public void clearSelection() {
        this.treeTableModel.selectedRoles.clear();
        this.rolesTree.revalidate();
        this.rolesTree.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTree().setEnabled(enabled);
    }

    private class RoleTreeTableModel
    extends BGTreeTableModel<RoleItem> {
        private final Icon folderIcon;
        private final Icon childIcon;
        private final Icon rootRoleIcon;
        private final List<RoleItem> selectedRoles;

        public RoleTreeTableModel() {
            super("roles");
            this.folderIcon = ClientUtils.getIcon((String)"fugue/rubber-balloons");
            this.childIcon = ClientUtils.getIcon((String)"fugue/rubber-balloon");
            this.rootRoleIcon = ClientUtils.getIcon((String)"fugue/tree");
            this.selectedRoles = new ArrayList<RoleItem>();
        }

        protected void initColumns() {
            if (RoleTreeTablePanel.this.rootNode == null) {
                RoleTreeTablePanel.this.rootNode = new RoleItem();
            }
            RoleTreeTablePanel.this.rootNode.setId(0);
            RoleTreeTablePanel.this.rootNode.setTitle("\u0420\u043e\u043b\u0438");
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", Role.class, false);
            if (RoleTreeTablePanel.this.isCheckedTree) {
                this.addColumn("", 10, 30, 30, "", false, (TableCellRenderer)new BooleanTableCellRenderer());
            }
            if (RoleTreeTablePanel.this.isShowMenu) {
                this.addColumn("\u041c\u0435\u043d\u044e", 100, 200, 400, "menuTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }
            this.addColumnId();
        }

        public Object getValue(RoleItem role, int column) throws Exception {
            if (column == 0) {
                return role == this.root ? RoleTreeTablePanel.this.rootNode : role;
            }
            if (RoleTreeTablePanel.this.isCheckedTree && column == 1) {
                return this.selectedRoles.contains((Object)role);
            }
            return super.getValue((Object)role, column);
        }

        public Icon getIcon(RoleItem role) {
            if (role == RoleTreeTablePanel.this.rootNode) {
                return this.rootRoleIcon;
            }
            if (Utils.isEmptyCollection(role.getChildren())) {
                return this.childIcon;
            }
            return this.folderIcon;
        }
    }

    public class CheckedTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final DefaultTreeCellRenderer label = new DefaultTreeCellRenderer();

        CheckedTreeCellRenderer() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
            this.setOpaque(false);
            this.label.setOpenIcon(ClientUtils.getIcon((String)"node.png"));
            this.label.setClosedIcon(ClientUtils.getIcon((String)"node.png"));
            this.label.setLeafIcon(ClientUtils.getIcon((String)"leaf.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Icon icon;
            this.label.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);
            if (node instanceof TreeNode && (icon = RoleTreeTablePanel.this.treeTableModel.getIcon((RoleItem)((Object)node))) != null) {
                this.label.setIcon(icon);
            }
            if (node instanceof GuiTitlable) {
                this.label.setText(((GuiTitlable)node).getGuiTitle());
            }
            this.invalidate();
            this.repaint();
            return this;
        }
    }
}

