/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class AttributeTypeDao
extends AbstractIdDao<AttributeType> {
    public AttributeTypeDao(Connection con, int moduleId) {
        super(con, "bill_attribute_type", moduleId);
    }

    public List<AttributeType> getAttributeTypeList() throws SQLException {
        return this.list(null, null, new Object[0]);
    }

    public AttributeType getAttributeTypeByName(String name) throws SQLException {
        return (AttributeType)this.get("name=?", new Object[]{name});
    }

    public Map<String, AttributeType> getAttributeTypeMap() throws SQLException {
        HashMap<String, AttributeType> attributeTypeMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : this.getAttributeTypeList()) {
            attributeTypeMap.put(attributeType.getName(), attributeType);
        }
        return attributeTypeMap;
    }

    protected void updateImpl(AttributeType attributeType) throws SQLException {
        String querySet = "name=?, title=?, `check`=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)attributeType, querySet);){
            int index = 1;
            ps.setString(index++, attributeType.getName());
            ps.setString(index++, attributeType.getTitle());
            ps.setString(index++, attributeType.getCheck());
            this.executeUpdate((Id)attributeType, index, ps);
        }
        catch (SQLIntegrityConstraintViolationException e) {
            throw new BGRuntimeException("\u0422\u0438\u043f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        }
    }

    public void deleteAttributeTypeByName(String name) throws SQLException {
        this.delete("name=?", new Object[]{name});
    }

    protected AttributeType getFromRS(ResultSet rs) throws SQLException {
        return AttributeType.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setName(rs.getString("name")).setCheck(rs.getString("check")).build();
    }
}

