/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.server.bean.Account;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.IdTitle;

public class AccountManager
extends AbstarctDaoConstant {
    public AccountManager(Connection con, int moduleId) {
        super(con, moduleId);
    }

    public List<Account> getAccountList() throws SQLException {
        ArrayList<Account> result = new ArrayList<Account>();
        String query = "SELECT bill_account_" + this.moduleId + ".*, contract_payment_types.title as payment_type FROM bill_account_" + this.moduleId + " LEFT JOIN contract_payment_types ON bill_account_" + this.moduleId + ".pid=contract_payment_types.id";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getAccountFromRS(rs));
            }
        }
        return result;
    }

    public List<BankAccount> getBankAccountList(int organizationId, Boolean inUse) throws SQLException {
        ArrayList<BankAccount> result = new ArrayList<BankAccount>();
        String query = "SELECT bill_account_" + this.moduleId + ".*, contract_payment_types.title as payment_type FROM bill_account_" + this.moduleId + " LEFT JOIN contract_payment_types ON bill_account_" + this.moduleId + ".pid=contract_payment_types.id WHERE true" + (String)(inUse != null ? " AND in_use=" + inUse.toString() : "") + (organizationId < 1 ? "" : " AND org_id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            if (organizationId > 0) {
                ps.setInt(1, organizationId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getBankAccountFromRS(rs));
                }
            }
        }
        return result;
    }

    public BankAccount getBankAccount(int id) throws SQLException {
        BankAccount bankAccount = null;
        String query = "SELECT bill_account_" + this.moduleId + ".*, contract_payment_types.title as payment_type FROM bill_account_" + this.moduleId + " LEFT JOIN contract_payment_types ON bill_account_" + this.moduleId + ".pid=contract_payment_types.id WHERE bill_account_" + this.moduleId + ".id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    bankAccount = this.getBankAccountFromRS(rs);
                }
            }
        }
        return bankAccount;
    }

    public void updateBankAccount(BankAccount bankAccount) {
        Objects.requireNonNull(bankAccount);
        try {
            boolean insert = bankAccount.getId() <= 0;
            String query = (insert ? "INSERT INTO " : "UPDATE ") + " bill_account_" + this.moduleId + " SET org_id=?, title=?, bank_title=?, account=?, bik=?, corr_account=?, pid=?, gr=?, comment=?, in_use=?" + (insert ? "" : " WHERE id=?");
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                int index = 1;
                ps.setInt(index++, bankAccount.getOrganizationId());
                ps.setString(index++, bankAccount.getTitle());
                ps.setString(index++, bankAccount.getBankTitle());
                ps.setString(index++, bankAccount.getAccount());
                ps.setString(index++, bankAccount.getBankIdentificationCode());
                ps.setString(index++, bankAccount.getCorrespondentAccount());
                ps.setInt(index++, bankAccount.getPaymentTypeId());
                ps.setLong(index++, bankAccount.getGroupMask());
                ps.setString(index++, bankAccount.getComment());
                ps.setBoolean(index++, bankAccount.isInUse());
                if (!insert) {
                    ps.setInt(index++, bankAccount.getId());
                }
                ps.executeUpdate();
                if (insert) {
                    bankAccount.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int updateAccount(Account account) {
        this.updateBankAccount(account.toBankAccount());
        return 0;
    }

    public void setDefaultBankAccount(int bankAccountId, int organizationId) throws SQLException {
        String query = "UPDATE bill_account_" + this.moduleId + " SET default_account=(id=?), in_use=if (id=?, true, in_use) WHERE org_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, bankAccountId);
            ps.setInt(2, bankAccountId);
            ps.setInt(3, organizationId);
            ps.executeUpdate();
        }
    }

    public BankAccount getDefaultBankAccount(int organizationId) {
        BankAccount result = null;
        String query = "SELECT ba.*, contract_payment_types.title AS payment_type FROM bill_account_" + this.moduleId + " AS ba LEFT JOIN contract_payment_types ON ba.pid=contract_payment_types.id WHERE ba.default_account=true AND org_id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, organizationId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getBankAccountFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private Account getAccountFromRS(ResultSet rs) throws SQLException {
        Account result = new Account();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setBankTitle(rs.getString("bank_title"));
        result.setAccount(rs.getString("account"));
        result.setBik(rs.getString("bik"));
        result.setCorr_account(rs.getString("corr_account"));
        result.setPid(rs.getInt("pid"));
        result.setPaymentType(rs.getString("payment_type"));
        result.setComment(rs.getString("comment"));
        result.setGroupMask(rs.getLong("gr"));
        return result;
    }

    private BankAccount getBankAccountFromRS(ResultSet rs) throws SQLException {
        return BankAccount.builder().setId(rs.getInt("id")).setOrganizationId(rs.getInt("org_id")).setTitle(rs.getString("title")).setBankTitle(rs.getString("bank_title")).setAccount(rs.getString("account")).setBankIdentificationCode(rs.getString("bik")).setCorrespondentAccount(rs.getString("corr_account")).setPaymentTypeId(rs.getInt("pid")).setPaymentType(rs.getString("payment_type")).setComment(rs.getString("comment")).setGroupMask(rs.getLong("gr")).setDefaultAccount(rs.getBoolean("default_account")).setInUse(rs.getBoolean("in_use")).build();
    }

    public int deleteBankAccount(int id) throws SQLException {
        int result = 0;
        String query = "DELETE FROM bill_account_" + this.moduleId + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            result = ps.executeUpdate();
        }
        return result;
    }

    public static int getPaymentTypeId(Connection con, int moduleId, int accountId) throws SQLException {
        int result = 0;
        if (accountId > 0) {
            String query = "SELECT pid FROM bill_account_" + moduleId + " WHERE id=" + accountId;
            try (PreparedStatement ps = con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }

    public List<IdTitle> getAccountTitleList(int organizationId, Boolean inUse) throws SQLException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        String query = "SELECT id, title, in_use FROM bill_account_" + this.moduleId + (String)(inUse == null ? "" : " WHERE in_use=" + inUse.toString()) + " AND org_id=? ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, organizationId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new IdTitle(rs.getInt(1), rs.getString(2)));
                }
            }
        }
        return result;
    }
}

