/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceProcessLog;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class VoiceProcessLogDao
extends AbstractDao<VoiceProcessLog> {
    public VoiceProcessLogDao(Connection con, int moduleId) {
        super(con, "voice_process_data", moduleId);
    }

    protected VoiceProcessLog getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceProcessLog result = new VoiceProcessLog();
        result.setDay((Date)rs.getDate("day"));
        result.setDeviceId(rs.getInt("deviceId"));
        return result;
    }

    protected void updateImpl(VoiceProcessLog voiceProcessLog) throws BGException, SQLException {
        String query = "REPLACE INTO " + this.tableName + " SET deviceId=?, day=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, voiceProcessLog.getDeviceId());
        ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)voiceProcessLog.getDay()));
        ps.executeUpdate();
        ps.close();
    }

    public List<VoiceProcessLog> list(int deviceId, Date dateFrom, Date dateTo) throws BGException {
        return super.list("deviceId=? AND day >= ? AND day < ? ", "day", new Object[]{deviceId, dateFrom, dateTo});
    }
}

