/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanelEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;

public class MultCostTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"discount");
    private JLabel view;
    private String multValue = "";
    private String multMode;
    private BGFloatTextField multTf;
    private ButtonGroup multButtonGroup;
    private BGUComboBox<TariffVar> tariffVars = new BGUComboBox();

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        try {
            this.vars.add(new TariffVar(0, "---"));
            if (tree.getParent() instanceof TariffPanelEditor) {
                int moduleId = this.getModuleId(parent);
                TariffPanelEditor tariffPanelEditor = (TariffPanelEditor)((Object)tree.getParent());
                this.vars.addAll(tariffPanelEditor.getTariffService().tariffVars(TariffVarType.MULT, Arrays.asList(tariffPanelEditor.getTariffPlanId(), 0)).stream().filter(a -> a.getModuleId() == moduleId || a.getModuleId() == 0).collect(Collectors.toList()));
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    @Override
    protected JPanel getEditorPanel() {
        this.multButtonGroup = new ButtonGroup();
        JPanel editor = new JPanel(new GridBagLayout());
        editor.add((Component)this.getMultConstPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        editor.add((Component)this.getMultVarPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        return editor;
    }

    private JPanel getMultConstPanel() {
        JRadioButton constMultMode = new JRadioButton("\u043c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c \u0446\u0435\u043d\u044b: ", true);
        constMultMode.setActionCommand("const");
        this.multButtonGroup.add(constMultMode);
        this.multTf = new BGFloatTextField(7);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)constMultMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.multTf, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getMultVarPanel() {
        JRadioButton varMultMode = new JRadioButton("\u043c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
        varMultMode.setActionCommand("var");
        this.multButtonGroup.add(varMultMode);
        this.tariffVars.setData(this.vars);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)varMultMode, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.tariffVars, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public Component getView() {
        this.extractData();
        StringBuffer title = new StringBuffer();
        if ("const".equals(this.multMode)) {
            title.append("\u041c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c \u0446\u0435\u043d\u044b: ");
            title.append(this.multValue);
        } else if ("var".equals(this.multMode)) {
            title.append("\u041c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c \u0446\u0435\u043d\u044b \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439: ");
            title.append((String)(this.tariffVar != null ? "< " + this.tariffVar.getTitle() + " [" + this.getTariffVarValue(this.tariffVar) + "] >" : "???"));
        }
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.view.setText(title.toString());
        return this.view;
    }

    @Override
    protected void loadData() {
        this.extractData();
        this.multTf.setText(this.multValue);
        this.multButtonGroup.getElements().asIterator().forEachRemaining(a -> {
            if (a.getActionCommand().equals(this.multMode)) {
                a.setSelected(true);
            }
        });
        this.tariffVars.setSelectedItem((Object)this.tariffVar);
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("value", this.multTf.getText());
        data.put("multMode", this.multButtonGroup.getSelection().getActionCommand());
        data.put("tariffVarId", String.valueOf(((TariffVar)this.tariffVars.getSelectedItem()).getId()));
        this.setDataInHash(data);
    }

    private void extractData() {
        Map<String, String> data = this.getDataInHash();
        this.multValue = Utils.maskNull((String)data.getOrDefault("value", "1"));
        this.multMode = data.getOrDefault("multMode", "const");
        int tariffVarId = Utils.parseInt((String)data.getOrDefault("tariffVarId", "0"), (int)0);
        this.tariffVar = this.vars.isEmpty() ? null : this.vars.stream().filter(a -> a.getId() == tariffVarId || a.getTopId() == tariffVarId).findFirst().orElse((TariffVar)((Object)this.vars.get(0)));
    }

    @Override
    public void loadFromXML(Element el) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("value", el.getAttribute("value"));
        data.put("multMode", el.getAttribute("multMode"));
        data.put("tariffVarId", el.getAttribute("tariffVarId"));
        this.setDataInHash(data);
        this.saveData();
    }

    @Override
    public void serializeToXML(Element el) {
        this.extractData();
        el.setAttribute("value", this.multValue);
        el.setAttribute("multMode", this.multMode);
        el.setAttribute("tariffVarId", String.valueOf(this.tariffVar.getId()));
    }

    @Override
    protected void editOk() {
        if ("var".equals(this.multButtonGroup.getSelection().getActionCommand()) && ((TariffVar)this.tariffVars.getSelectedItem()).getId() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
            return;
        }
        super.editOk();
    }
}

