/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.idealer.DealerFindException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class DealerManager
extends AbstarctDaoConstant {
    public DealerManager(Connection con, int moduleId) {
        super(con, "card_dealer", moduleId);
    }

    public Dealer getDealer(String login, String pswd) throws SQLException, DealerFindException {
        Dealer result;
        block17: {
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                throw new DealerFindException("14", "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f (mid)!");
            }
            result = null;
            String query = "SELECT * FROM " + this.tableName + " WHERE login=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setString(1, login);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = this.getDealerFromRS(rs);
                        if (result.getError() > 5) {
                            result = null;
                            throw new DealerFindException("6", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u044b\u0445 \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f. \u041b\u043e\u0433\u0438\u043d \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d.");
                        }
                        if (!rs.getString("pswd").equals(pswd)) {
                            this.incDealerError(result.getId());
                            result = null;
                            throw new DealerFindException("2", "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c!");
                        }
                        if (!TimeUtils.dateInPeriod((LocalDate)LocalDate.now(), (Period)result.getPeriod())) {
                            result = null;
                            throw new DealerFindException("4", "\u0412\u044b \u0432\u043d\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438!");
                        }
                        break block17;
                    }
                    throw new DealerFindException("1", "\u041b\u043e\u0433\u0438\u043d \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                }
            }
        }
        return result;
    }

    public List<Dealer> getDealersByContractId(int contractId, int type) throws SQLException {
        ArrayList<Dealer> result = new ArrayList<Dealer>();
        String query = "SELECT * FROM " + this.tableName + " WHERE contract_id=?";
        if (type != 0) {
            query = query + " AND (type & " + type + ") > 0 ";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getDealerFromRS(rs));
                }
            }
        }
        return result;
    }

    public List<Dealer> getDealerList(String title, Period period, int type) throws SQLException {
        ArrayList<Dealer> result = new ArrayList<Dealer>();
        LocalDate from = Optional.ofNullable(period).map(a -> a.getLocalDateFrom()).orElse(null);
        LocalDate until = Optional.ofNullable(period).map(a -> a.getLocalDateTo()).orElse(null);
        StringBuffer query = new StringBuffer("SELECT * FROM ").append(this.tableName).append(" WHERE true");
        Optional.ofNullable(title).filter(a -> !a.isBlank()).ifPresent(a -> query.append(" AND title REGEXP ?"));
        if (type != 0) {
            query.append(" AND (type & ?)>0");
        }
        Optional.ofNullable(from).ifPresent(a -> query.append(" AND ( isNull(date1) or date1>=? )"));
        Optional.ofNullable(until).ifPresent(a -> query.append(" AND ( isNull(date2) or date2<=? )"));
        query.append(" ORDER BY title");
        int i = 1;
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (title != null && title.trim().length() > 0) {
                ps.setString(i++, title);
            }
            if (type != 0) {
                ps.setInt(i++, type);
            }
            if (from != null) {
                ps.setDate(i++, TimeUtils.convertLocalDateToSqlDate((LocalDate)from));
            }
            if (until != null) {
                ps.setDate(i++, TimeUtils.convertLocalDateToSqlDate((LocalDate)until));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getDealerFromRS(rs));
                }
            }
        }
        return result;
    }

    public void incDealerError(int id) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET error=error+1 WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    @Deprecated
    public void incDealerFinded(int id) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET st_finded=st_finded + 1 WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public void incDealerFinded(int id, int count) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET st_finded=st_finded+? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, count);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
    }

    public void incDealerPayed(int id) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET st_payed=st_payed+1 WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    private Dealer getDealerFromRS(ResultSet rs) throws SQLException {
        return new Dealer(rs.getInt("id"), rs.getString("title")).setPeriod(new Period((Date)rs.getDate("date1"), (Date)rs.getDate("date2"))).setParams(rs.getInt("params")).setFindmodes(rs.getLong("findmodes")).setAllowcontracts(rs.getLong("allowcontracts")).setAllowcontractsMode(rs.getInt("allowcontracts_mode")).setIp(rs.getString("ip")).setPt(rs.getString("pt")).setType(rs.getInt("type")).setContractId(rs.getInt("cid")).setCardPercent(rs.getFloat("card_percent")).setPayPercent(rs.getFloat("pay_percent")).setCardContract(rs.getString("card_contract")).setPayContract(rs.getString("pay_contract")).setCanselTime(rs.getInt("cansel_time")).setLogin(rs.getString("login")).setPassword(rs.getString("pswd")).setError(rs.getInt("error")).setComment(rs.getString("comment")).setStatRequest(rs.getInt("st_request")).setStatFinded(rs.getInt("st_finded")).setStatPayed(rs.getInt("st_payed")).setPayComissionType(rs.getInt("pay_comission_type")).setContractId(rs.getInt("contract_id"));
    }
}

