/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.buyemoney.common.BuyemoneyStatus;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyPayment;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.CurrencyRate;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolCurrency;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.util.BGMoney;

public class BuyemoneyManager
extends AbstarctDaoConstant {
    private final String TABLE_BUYEMONEY_PAYMENT;
    private static Pattern pcontr = Pattern.compile("\\$\\{contract\\}");
    private static Pattern pcontrComment = Pattern.compile("\\$\\{contract_comment\\}");
    private static Pattern pUserComment = Pattern.compile("\\$\\{user_comment\\}");
    private static Pattern pSumtotal = Pattern.compile("\\$\\{sumtotal\\}");
    private static Pattern pSumcur = Pattern.compile("\\$\\{sumcur\\}");
    private static Pattern pDate = Pattern.compile("\\$\\{date\\}");
    private static Pattern pId = Pattern.compile("\\$\\{id\\}");
    private static Pattern pRatePrice = Pattern.compile("\\$\\{rateprice\\}");
    private static Pattern pPurse = Pattern.compile("\\$\\{purse\\}");
    private static Pattern pCur = Pattern.compile("\\$\\{cur\\}");

    public BuyemoneyManager(Connection con, int moduleId) {
        super(con, "buyemoney_rate", moduleId);
        this.TABLE_BUYEMONEY_PAYMENT = "buyemoney_payment_" + moduleId;
    }

    public CurrencyRate getCurrencyRate(int id) throws SQLException {
        CurrencyRate result = null;
        String query = "SELECT * FROM " + this.tableName + " as rate WHERE id=" + id;
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery(query);
        if (rs.next()) {
            result = this.getCurrencyRateFromRS(rs);
        }
        rs.close();
        st.close();
        return result;
    }

    public List<CurrencyRate> getCurrencyRateList(java.util.Date date, Boolean enabled) throws SQLException {
        ArrayList<CurrencyRate> list = new ArrayList<CurrencyRate>();
        int index = 1;
        String query = "SELECT * FROM " + this.tableName + " as rate WHERE (1)";
        if (date != null) {
            query = query + " AND (date1 IS NULL OR TO_DAYS(date1)<=TO_DAYS(?)) AND (date2 IS NULL OR TO_DAYS(?)<=TO_DAYS(date2))";
        }
        if (enabled != null) {
            query = query + " AND (enabled=?)";
        }
        PreparedStatement st = this.con.prepareStatement(query);
        if (date != null) {
            st.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)date));
            st.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)date));
        }
        if (enabled != null) {
            st.setBoolean(index++, enabled);
        }
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            list.add(this.getCurrencyRateFromRS(rs));
        }
        rs.close();
        st.close();
        return list;
    }

    public void updateCurrencyRate(CurrencyRate curr) throws SQLException {
        String query = null;
        query = curr.getId() > 0 ? "UPDATE " + this.tableName + " SET cur=?, price=?, date1=?, date2=?, enabled=? WHERE id=?" : "INSERT INTO " + this.tableName + " (cur,price,date1,date2,enabled) VALUES (?,?,?,?,?)";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, curr.getProtocolCurrency());
        ps.setBigDecimal(2, curr.getPrice().toBigDecimal());
        ps.setDate(3, TimeUtils.convertDateToSqlDate((java.util.Date)curr.getPeriod().getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate((java.util.Date)curr.getPeriod().getDateTo()));
        ps.setBoolean(5, curr.isEnabled());
        if (curr.getId() > 0) {
            ps.setInt(6, curr.getId());
        }
        ps.executeUpdate();
        ps.close();
    }

    public void deleteCurrencyRate(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=" + id;
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public int getCountUsedCurrencyRate(int id) throws SQLException {
        int countUsed = 0;
        String query = "SELECT count(*) FROM " + this.TABLE_BUYEMONEY_PAYMENT + " WHERE rate_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    countUsed = rs.getInt(1);
                }
            }
        }
        return countUsed;
    }

    private CurrencyRate getCurrencyRateFromRS(ResultSet rs) throws SQLException {
        CurrencyRate currency = new CurrencyRate();
        currency.setId(rs.getInt("rate.id"));
        currency.setProtocolCurrency(rs.getInt("rate.cur"));
        currency.setPrice(new BGMoney(rs.getBigDecimal("rate.price")));
        currency.setPeriod(new Period());
        currency.getPeriod().setDateFrom((java.util.Date)rs.getTimestamp("rate.date1"));
        currency.getPeriod().setDateTo((java.util.Date)rs.getTimestamp("rate.date2"));
        currency.setEnabled(rs.getBoolean("rate.enabled"));
        return currency;
    }

    public List<BuyemoneyPayment> getPaymentList(int fCid, Period fPeriod, int fCurrency, String fGroups, String fContract) throws SQLException {
        ArrayList<BuyemoneyPayment> list = new ArrayList<BuyemoneyPayment>();
        StringBuffer query = new StringBuffer("SELECT payment.*, contract.title, contract.comment AS con_comment, rate.* FROM " + this.TABLE_BUYEMONEY_PAYMENT + " AS payment LEFT JOIN contract ON contract.id=payment.cid LEFT JOIN " + this.tableName + " as rate ON rate.id=payment.rate_id WHERE (1)");
        if (fCid > 0) {
            query.append("AND(payment.cid=?)");
        }
        if (fPeriod != null) {
            if (fPeriod.getDateFrom() != null) {
                query.append("AND(TO_DAYS(payment.dt)>=TO_DAYS(?))");
            }
            if (fPeriod.getDateTo() != null) {
                query.append("AND(TO_DAYS(payment.dt)<=TO_DAYS(?))");
            }
        }
        if (fCurrency > 0) {
            query.append("AND(rate.cur=?)");
        }
        long grMask = Utils.enumToMask((String)fGroups);
        if (!Utils.isEmptyString((String)fGroups) && grMask > 0L) {
            query.append("AND(contract.gr&?>0)");
        }
        if (!Utils.isEmptyString((String)fContract)) {
            query.append("AND(contract.title LIKE ?)");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int i = 1;
        if (fCid > 0) {
            ps.setInt(i++, fCid);
        }
        if (fPeriod != null) {
            if (fPeriod.getDateFrom() != null) {
                ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((java.util.Date)fPeriod.getDateFrom()));
            }
            if (fPeriod.getDateTo() != null) {
                ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((java.util.Date)fPeriod.getDateTo()));
            }
        }
        if (fCurrency > 0) {
            ps.setInt(i++, fCurrency);
        }
        if (!Utils.isEmptyString((String)fGroups) && grMask > 0L) {
            ps.setLong(i++, grMask);
        }
        if (!Utils.isEmptyString((String)fContract)) {
            ps.setString(i++, "%" + fContract + "%");
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            list.add(this.getPaymentFromRS(rs, true));
        }
        rs.close();
        ps.close();
        return list;
    }

    public Map<Integer, List<BuyemoneyPayment>> getUnstatusedPaymentMap() throws SQLException {
        return this.getProtocolPaymentMap(null, null, BuyemoneyStatus.NEW);
    }

    public Map<Integer, List<BuyemoneyPayment>> getProtocolPaymentMap(java.util.Date datetime1, java.util.Date datetime2, BuyemoneyStatus status) throws SQLException {
        HashMap<Integer, List<BuyemoneyPayment>> map = new HashMap<Integer, List<BuyemoneyPayment>>();
        String query = "SELECT payment.*, contract.title, contract.comment AS con_comment, rate.* FROM " + this.TABLE_BUYEMONEY_PAYMENT + " AS payment LEFT JOIN contract ON contract.id=payment.cid LEFT JOIN " + this.tableName + " as rate ON rate.id=payment.rate_id WHERE (1)";
        if (datetime1 != null) {
            query = query + " AND payment.dt>=?";
        }
        if (datetime2 != null) {
            query = query + " AND payment.dt<=?";
        }
        if (status != null) {
            query = query + " AND payment.status=?";
        }
        PreparedStatement ps = this.con.prepareStatement(query);
        int index = 1;
        if (datetime1 != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)datetime1));
        }
        if (datetime2 != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)datetime2));
        }
        if (status != null) {
            ps.setInt(index++, BuyemoneyStatus.NEW.getCode());
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            BuyemoneyPayment payment = this.getPaymentFromRS(rs, true);
            ArrayList<BuyemoneyPayment> list = (ArrayList<BuyemoneyPayment>)map.get(payment.getRate().getProtocolCurrency());
            if (list == null) {
                list = new ArrayList<BuyemoneyPayment>();
                map.put(payment.getRate().getProtocolCurrency(), list);
            }
            list.add(payment);
        }
        rs.close();
        ps.close();
        return map;
    }

    public int getFirstYear(int cid) throws SQLException {
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery("SELECT MIN(dt) FROM " + this.TABLE_BUYEMONEY_PAYMENT + " WHERE cid=" + cid);
        Date date = null;
        if (rs.next()) {
            date = rs.getDate(1);
        }
        rs.close();
        st.close();
        return (date != null ? TimeUtils.convertDateToCalendar((java.util.Date)date) : new GregorianCalendar()).get(1);
    }

    public void addPayment(BuyemoneyPayment payment) throws SQLException {
        String query = "INSERT INTO " + this.TABLE_BUYEMONEY_PAYMENT + " (cid, dt, rate_id, sumcur, sumtotal, status, comment, purse) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        ps.setInt(1, payment.getCid());
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((java.util.Date)payment.getDate()));
        ps.setInt(3, payment.getRateId());
        ps.setBigDecimal(4, payment.getSumcur().toBigDecimal());
        ps.setBigDecimal(5, payment.getSumtotal().toBigDecimal());
        ps.setInt(6, payment.getStatus().getCode());
        ps.setString(7, payment.getComment());
        ps.setString(8, payment.getPurse());
        ps.executeUpdate();
        payment.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        ps.close();
    }

    public void deletePayment(int id) throws SQLException {
        String query = "DELETE FROM " + this.TABLE_BUYEMONEY_PAYMENT + " WHERE id=" + id;
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public void updatePayment(BuyemoneyPayment payment) throws SQLException {
        String query = "UPDATE " + this.TABLE_BUYEMONEY_PAYMENT + " SET cid=?, dt=?, rate_id=?, sumcur=?, sumtotal=?, charge_id=?, status=?, comment=?, purse=? WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, payment.getCid());
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((java.util.Date)payment.getDate()));
        ps.setInt(3, payment.getRateId());
        ps.setBigDecimal(4, payment.getSumcur().toBigDecimal());
        ps.setBigDecimal(5, payment.getSumtotal().toBigDecimal());
        ps.setInt(6, payment.getChargeId());
        ps.setInt(7, payment.getStatus().getCode());
        ps.setString(8, payment.getComment());
        ps.setString(9, payment.getPurse());
        ps.setInt(10, payment.getId());
        ps.executeUpdate();
        ps.close();
    }

    public BuyemoneyPayment getPaymentFromRS(ResultSet rs, boolean fillExtend) throws SQLException {
        BuyemoneyPayment payment = new BuyemoneyPayment();
        payment.setId(rs.getInt("id"));
        payment.setCid(rs.getInt("cid"));
        payment.setDate(rs.getTimestamp("dt"));
        payment.setRateId(rs.getInt("rate_id"));
        payment.setSumcur(new BGMoney(rs.getBigDecimal("sumcur")));
        payment.setSumtotal(new BGMoney(rs.getBigDecimal("sumtotal")));
        payment.setChargeId(rs.getInt("charge_id"));
        payment.setStatus((BuyemoneyStatus)Utils.getListItemEnumFromId(BuyemoneyStatus.class, (int)rs.getInt("status")));
        payment.setComment(rs.getString("comment"));
        payment.setPurse(rs.getString("purse"));
        if (fillExtend) {
            payment.setContractTitle(rs.getString("contract.title"));
            payment.setContractComment(rs.getString("con_comment"));
            payment.setRate(this.getCurrencyRateFromRS(rs));
        }
        return payment;
    }

    public void carryOutCharge(BuyemoneyPayment payment, int chargeType, String chargeComment) throws Exception {
        if (payment != null && payment.getStatus() == BuyemoneyStatus.OK) {
            Charge charge = new Charge().setContractId(payment.getCid()).setTypeId(chargeType).setDate(payment.getDate()).setSum(payment.getSumtotal().toBigDecimal()).setUserId(0).setComment(chargeComment);
            new ChargeDao(this.con).update((Object)charge);
            Contract contract = ContractDao.getContract((Connection)this.con, (int)payment.getCid());
            ServerUtils.commitConnection((Connection)this.con);
            try (BalanceUtils bu = new BalanceUtils(this.con);){
                bu.updateBalance(payment.getDate(), contract);
            }
            ServerUtils.commitConnection((Connection)this.con);
            EventProcessor.getInstance().publish((Event)new ChargeEvent(0, charge));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 4, charge.getSum()));
            payment.setChargeId(charge.getId());
        }
    }

    public String formatComment(String pattern, BuyemoneyPayment payment, String userComment, ProtocolManager protocolManager) throws SQLException {
        CurrencyRate rate = payment.getRate() != null ? payment.getRate() : this.getCurrencyRate(payment.getRateId());
        String desc = pSumtotal.matcher(pattern).replaceAll(payment.getSumtotal() != null ? payment.getSumtotal().toString() : "?");
        desc = pSumcur.matcher(desc).replaceAll(payment.getSumcur() != null ? payment.getSumcur().toString() : "?");
        desc = pDate.matcher(desc).replaceAll(TimeUtils.format((java.util.Date)payment.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
        desc = pId.matcher(desc).replaceAll(String.valueOf(payment.getId()));
        desc = pRatePrice.matcher(desc).replaceAll(rate.getPrice() != null ? rate.getPrice().toString() : "?");
        desc = pPurse.matcher(desc).replaceAll(payment.getPurse() != null ? payment.getPurse() : "?");
        Object curTitle = null;
        ProtocolCurrency pcurrency = protocolManager.getProtocols().get(rate.getProtocolCurrency());
        curTitle = pcurrency != null ? pcurrency.getConfig().get("title", "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b-\u0432\u0430\u043b\u044e\u0442\u044b #" + rate.getProtocolCurrency()) : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b-\u0432\u0430\u043b\u044e\u0442\u0430 #" + rate.getProtocolCurrency();
        desc = pCur.matcher(desc).replaceAll((String)curTitle);
        try {
            Contract contract = ContractDao.getContract((Connection)this.con, (int)payment.getCid());
            desc = pcontr.matcher(desc).replaceAll(contract.getTitle() != null ? contract.getTitle() : "?");
            desc = pcontrComment.matcher(desc).replaceAll(contract.getComment() != null ? contract.getComment() : "?");
            desc = pUserComment.matcher(desc).replaceAll(userComment != null ? userComment : "?");
        }
        catch (BGException ex) {
            this.logError(ex);
        }
        return desc;
    }
}

