/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.CalendarPanel;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;

public class ContractParamDateEditorDialog
extends BGEditorDialog<ContractParamEditorData> {
    private CalendarPanel controlPanelDate = new CalendarPanel(false);

    public ContractParamDateEditorDialog(String title, ContractParamEditorData data) {
        super(title, data);
    }

    @Override
    public void doDialogPanel() {
        this.panel.add((Component)new BGTitleLabel(((ContractParamEditorData)this.data).parameterTitle), new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.panel.add((Component)this.getDatePanel(), new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.panel.add((Component)this.getCalendarPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.panel.add((Component)this.getPresetPanel(), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        switch (((ContractParamEditorData)this.data).entityType) {
            case NEW_CONTRACT_PARAMETER: 
            case CONTRACT_PARAMETER: {
                if (((ContractParamEditorData)this.data).getValue() == null) break;
                this.controlPanelDate.setCalendar(TimeUtils.convertDateToCalendar(((EntityAttrDate)((ContractParamEditorData)this.data).getValue()).getValue()));
                break;
            }
        }
    }

    @Override
    public boolean doApply() throws Exception {
        this.controlPanelDate.doOk();
        Calendar newDate = this.controlPanelDate.getCalendar();
        EntityAttrDate attrDate = new EntityAttrDate(((ContractParamEditorData)this.data).contractId, ((ContractParamEditorData)this.data).parameterId, newDate != null ? newDate.getTime() : null);
        switch (((ContractParamEditorData)this.data).entityType) {
            case NEW_CONTRACT_PARAMETER: {
                ((ContractParamEditorData)this.data).value = newDate == null ? null : attrDate;
                break;
            }
            case CONTRACT_PARAMETER: {
                ((ContractParamEditorData)this.data).clientContext.getWebService(ContractService.class, 0).contractParameterDateUpdate(((ContractParamEditorData)this.data).contractId, attrDate);
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ContractParamEditorData)this.data).contractId));
                break;
            }
        }
        return true;
    }

    private JPanel getDatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        return panel;
    }

    private JPanel getCalendarPanel() {
        this.controlPanelDate.setCalendar(new GregorianCalendar());
        this.controlPanelDate.addPropertyChangeListener(e -> {
            if ("updateCalendar".equals(e.getPropertyName())) {
                ((JButton)this.optionPane.getOptions()[0]).doClick();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.controlPanelDate, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getPresetPanel() {
        ActionListener actionListener = a -> {
            this.controlPanelDate.setCalendar(TimeUtils.parseCalendar(a.getActionCommand(), "dd.MM.yyyy"));
            ((JButton)this.optionPane.getOptions()[0]).doClick();
        };
        LocalDate date = LocalDate.now();
        LocalDate nextMontrh = date.withDayOfMonth(1).plusMonths(1L);
        LocalDate next2Montrh = date.withDayOfMonth(1).plusMonths(2L);
        JPanel panel = new JPanel(new GridBagLayout());
        date = date.minusDays(1L);
        for (int i = 1; i < 6; ++i) {
            panel.add((Component)this.getButton(date, actionListener), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            date = date.plusDays(1L);
        }
        panel.add((Component)this.getButton(nextMontrh, actionListener), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.getButton(next2Montrh, actionListener), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private BGButton getButton(LocalDate date, ActionListener actionListener) {
        String dateText = TimeUtils.format(date, "dd.MM.yyyy");
        BGButton button = new BGButton(dateText);
        button.setActionCommand(dateText);
        button.addActionListener(actionListener);
        return button;
    }
}

