<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<!-- отчет по платежам и расходам -->
<table>
	<tr><td>
		<table class="table tableWidth tableFont balanceList">
			<thead><tr><td>Описание</td><td>Сумма, ${currencyTitleMedium}</td></tr></thead>
			<tbody>
			  <tr>
			  	<td style="text-align: left;">Входящий остаток на начало месяца</td>
			  	<td><fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['summa1']}"/></td>
			  </tr>
			  <tr>
			  	<td style="text-align: left;">Приход за месяц (всего)</td>
			  	<td><fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['summa2']}"/></td>
			  </tr>
			  <c:if test="${not empty dataMap['paymentList']}">
			  <c:forEach var="item" items="${dataMap['paymentList']}">
			  <tr>
				<td style="text-align: left; color: #555555; padding-left: 20px;"><fmt:formatDate value="${item.date}"/> <b>${dataMap['paymentTypeMap'][item.id].title}</b> <c:if test="${not empty item.comment}"> <i>( ${item.comment} )</i></c:if></td>
				<td><fmt:formatNumber type="number" pattern="###,###,##0.00" value="${item.summa}"/></td>
			  </tr>
			  </c:forEach>
			  </c:if>
			  <tr>
			  <td style="text-align: left;">Расход за месяц (всего)</td>
			  <td><fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['summa4']}"/></td>
			  </tr>
			  <c:if test="${not empty dataMap['chargeList']}">
			  <c:forEach var="item" items="${dataMap['chargeList']}">
			  <tr>
				<td style="text-align: left; color: #555555; padding-left: 20px;">${item[0]}</td>
				<td><fmt:formatNumber type="number" pattern="###,###,##0.00" value="${item[1]}"/></td>
			  </tr>
			  </c:forEach>
			  </c:if>
			  <tr>
			  <td style="text-align: left;">Наработка за месяц (всего)</td>
			  <td><fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['summa3']}"/></td>
			  </tr>
			  <c:if test="${not empty dataMap['accountList']}">
			  <c:forEach var="item" items="${dataMap['accountList']}">
			  <tr>
				<td style="text-align: left; color: #555555; padding-left: 20px;">${item[0]}</td>
				<td><fmt:formatNumber type="number" pattern="###,###,##0.00" value="${item[1]}"/></td>
			  </tr>
			  </c:forEach>
			  </c:if>
			  <tr>
				  <td style="text-align: left;">Исходящий остаток на конец месяца</td>
				  <td><fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['summa5']}"/></td>
			  </tr>
			  <c:if test="${contract.balanceMode == 1}">
			  <tr>
				  <td style="text-align: left;">Лимит</td>
				  <td><fmt:formatNumber type="number" pattern="###,###,##0.00" value="${dataMap['limit']}"/></td>
			  </tr>
			  </c:if>
			 </tbody>
		</table>
		<c:forEach  var="item"  items="${dataMap['messages']}"><br/>${item}</c:forEach>
		
	</td></tr>
	<tr class="foot"><td>
		<c:if test="${dataMap['has_independent_subs']==1}">
			<br>
			<form method='GET' action='' style="margin: 0px 0px;">
				<input type="hidden" name="action" value="DistributeBalance"/>
				<input type="hidden" name="module" value="contract"/>
				<input type="hidden" name="mid" value="0"/>
				<input type="submit" value="Перенос средств"/> 
			</form>
		</c:if>
	</td></tr>
</table>

<div id="contractBalance" style="display: none"></div>