/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.publish.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.stream.Stream;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.list.renderer.DirectoryListCellRenderer;
import ru.bitel.bgbilling.kernel.event.publish.client.DirectoryPanel;
import ru.bitel.bgbilling.kernel.event.publish.client.MQEventPanel;
import ru.bitel.bgbilling.kernel.event.publish.client.MQServerPanel;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.IdTitle;

public class PublishEventPanel
extends BGUTabPanel {
    public static final String TAB_ID = "publishEvent";
    private DefaultListModel<IdTitle> directoryListModel = new DefaultListModel();
    private JList<IdTitle> directoryList = new JList<IdTitle>(this.directoryListModel);
    private IdTitle currentDirectory = null;
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private final DirectoryPanel[] panels = new DirectoryPanel[]{new MQServerPanel(), new MQEventPanel()};

    public PublishEventPanel() {
        this(new ClientContext("kernel.publish.event", 0, 0, "setup"), "\u041f\u0443\u0431\u043b\u0438\u043a\u0430\u0446\u0438\u044f \u0441\u043e\u0431\u044b\u0442\u0438\u0439");
    }

    public PublishEventPanel(ClientContext clientContext, String tabTitle) {
        super(clientContext);
        this.setTabId(TAB_ID);
        this.setTabTitle(tabTitle);
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getLeftPanel(), (Component)this.getRightPanel(), 200L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.directoryList.setSelectedIndex(0);
    }

    private JPanel getLeftPanel() {
        this.directoryList.setCellRenderer(new DirectoryListCellRenderer());
        this.directoryList.setSelectionMode(0);
        Stream.of(this.panels).forEach(e -> this.directoryListModel.addElement(new IdTitle(e.getId(), e.getTitle())));
        this.directoryList.addListSelectionListener(e -> {
            IdTitle idTitle = this.directoryList.getSelectedValue();
            if (idTitle != null && !idTitle.equals(this.currentDirectory)) {
                this.cardLayout.show(this.cardPanel, this.panels[idTitle.getId()].getCardName());
                this.currentDirectory = idTitle;
                this.performAction("refresh");
            }
        });
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.directoryList), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRightPanel() {
        Stream.of(this.panels).forEach(e -> this.cardPanel.add((Component)e, e.getCardName()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.cardPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if (this.currentDirectory != null) {
                this.panels[this.currentDirectory.getId()].performAction("refresh");
            }
        });
        new AbstractBGUPanel.BGActionNew(e -> {
            if (this.currentDirectory != null) {
                this.panels[this.currentDirectory.getId()].performAction("new");
            }
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            if (this.currentDirectory != null) {
                this.panels[this.currentDirectory.getId()].performAction("edit");
            }
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            if (this.currentDirectory != null) {
                this.panels[this.currentDirectory.getId()].performAction("delete");
            }
        });
    }
}

