/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ServiceConfigMonitor
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private BGComboBox<ComboBoxItem> packageCb = new BGComboBox();
    private BGIntTextField daysTf = new BGIntTextField();
    private JPanel editorPanel = new JPanel(new GridBagLayout());
    private JTextArea commentTa = new JTextArea();
    private JButton openContractButton = new JButton();
    private String contractId;
    private String contractTitle;

    public ServiceConfigMonitor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "monitor");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServiceConfigMonitor.this.id = ClientUtils.getRowId((BGTable)ServiceConfigMonitor.this.table);
                    ServiceConfigMonitor.this.startEdit();
                }
            }
        });
        this.openContractButton.addActionListener(e -> ClientUtils.openContract((int)Utils.parseInt((String)this.contractId)));
        this.editorPanel.setVisible(false);
        this.editorPanel.setMinimumSize(new Dimension(100, 200));
        this.editorPanel.setPreferredSize(new Dimension(100, 200));
    }

    private void jbInit() throws Exception {
        this.daysTf.setText("5");
        JButton updateButton = new JButton(">>>");
        updateButton.addActionListener(e -> this.setData());
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041f\u0430\u043a\u0435\u0442:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.packageCb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0414\u043d\u0435\u0439 \u0434\u043e \u0438\u0441\u0442\u0435\u0447\u0435\u043d\u0438\u044f:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)this.daysTf, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 10), 0, 0));
        filterPanel.add((Component)updateButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editorPanel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.openContractButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.editorPanel.add((Component)new JLabel("\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)new JScrollPane(this.commentTa), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editorPanel.add((Component)okCancel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editorPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData() {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("MonitorTable");
        req.setModuleId(this.getModuleId());
        req.setAttribute("days", this.daysTf.getText());
        req.setAttribute("package", ClientUtils.getIdFromComboBox(this.packageCb));
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData((Node)XMLUtils.getElement((Document)doc, (String)"table"));
        }
    }

    private void init() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("PackageList");
        req.setModuleId(this.getModuleId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.packageCb, (Node)XMLUtils.getElement((Document)doc, (String)"list"), (String)"");
        }
        this.packageCb.insertItemAt((Object)new ComboBoxItem(0, "-- \u043b\u044e\u0431\u043e\u0439 --"), 0);
    }

    public void editItem() {
        this.id = ClientUtils.getRowId((BGTable)this.table);
        if (this.id != 0) {
            this.startEdit();
        }
    }

    private void startEdit() {
        this.contractId = ClientUtils.getRowId((BGTable)this.table, null, (String)"cid");
        this.contractTitle = ClientUtils.getRowId((BGTable)this.table, null, (String)"contract");
        this.openContractButton.setText(this.contractTitle);
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("ContractPackageGet");
        req.setAttribute("mid", this.getModuleId());
        req.setAttribute("id", this.id);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                this.commentTa.setText(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)doc, (String)"//contract_package/admin_comment")));
                this.openContractButton.setText(this.contractTitle);
                this.editorPanel.setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("ContractPackageAdminCommentUpdate");
            req.setModuleId(this.getModuleId());
            req.setAttribute("id", this.id);
            req.setAttribute("comment", this.commentTa.getText());
            if (ClientUtils.checkStatus((Document)this.getDocument(req))) {
                this.setData();
                this.editorPanel.setVisible(false);
            }
        } else {
            this.editorPanel.setVisible(false);
        }
    }
}

