/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostDevice;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostIntercomService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostIntercomRuntime;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseParamData;
import ru.bitel.common.Utils;

public class TableForpostIntercomDeviceEdit
extends BGTableInfoBase {
    private List<SmartHouseParamData> params;

    public TableForpostIntercomDeviceEdit() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", (String)"name").setWidth(400), BGUTableColumn.buildColumnTextLeft((String)"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", (String)"value").setWidth(-1)};
        this.params = Arrays.asList(new SmartHouseParamData("TypeID", "list:device_type", "\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430", ""), new SmartHouseParamData("Description", "text", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435) \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430", ""), new SmartHouseParamData("Host", "text", "\u0421\u0435\u0442\u0435\u0432\u043e\u0439 \u0430\u0434\u0440\u0435\u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430", ""), new SmartHouseParamData("Port", "integer", "\u0421\u0435\u0442\u0435\u0432\u043e\u0439 \u043f\u043e\u0440\u0442 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u043f\u043e \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d API \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430", ""), new SmartHouseParamData("Settings", "text", "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0432 \u0432\u0438\u0434\u0435 \u043f\u0430\u0440\u044b \u043a\u043b\u044e\u0447 - \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435, \u0437\u0430\u0432\u0438\u0441\u044f\u0449\u0438\u0435 \u043e\u0442 \u0442\u0438\u043f\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 JSON", ""), new SmartHouseParamData("CameraIDList", "ids:camera", "\u0421\u043f\u0438\u0441\u043e\u043a \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u043a\u0430\u043c\u0435\u0440", ""));
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        int userId = Utils.parseInt((String)tableParams.get("id"));
        int accountId = Utils.parseInt((String)tableParams.get("accountId"));
        ForpostDevice forpostDevice = null;
        if (userId > 0) {
            ForpostIntercomRuntime forpostIntercomRuntime = ForpostIntercomRuntime.getInstance(moduleId);
            forpostDevice = forpostIntercomRuntime.getAccountDevices(accountId).stream().filter(a -> a.getId() == userId).findFirst().orElse(null);
        } else {
            forpostDevice = ((ForpostIntercomService)this.getContext().getService(ForpostIntercomService.class, moduleId)).forpostIntercomDeviceDefault();
        }
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        for (SmartHouseParamData data : this.params) {
            String value = switch (data.getName()) {
                case "TypeID" -> String.valueOf(forpostDevice.getTypeId());
                case "Description" -> forpostDevice.getDescription();
                case "Settings" -> forpostDevice.getSettings();
                default -> forpostDevice.getString(data.getName());
            };
            BGUTableRowData rowData = new BGUTableRowData().addValue("name", data.getName()).addValue("type", data.getType()).addValue("title", data.getTitle()).addValue("value", value);
            rowDatas.add(rowData);
        }
        return rowDatas;
    }
}

