/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.load;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import bitel.billing.module.services.load.SourceEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ServiceConfigSources
extends ServiceConfigTabbedPanel {
    private SourceEditor sourceEditor = new SourceEditor();
    private SourceTableModel sourceTableModel = new SourceTableModel();

    public ServiceConfigSources() {
        this.tryCall(() -> this.jbInit());
    }

    private void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.sourceTableModel);
        table.setSelectionMode(0);
        this.sourceEditor.setVisible(false);
        this.sourceEditor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServiceConfigSources.this.editor_componentHidden(e);
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.sourceEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGSwingUtilites.handleLDMouseClicked(table, e -> this.editItem());
    }

    @Override
    public void setData() throws Exception {
        Request request = new Request().setModule("load").setModuleId(this.getModuleId()).setAction("SourceInfo");
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) throws Exception {
        if (ClientUtils.checkStatus(doc)) {
            ArrayList<SourceData> list = new ArrayList<SourceData>();
            for (Element item : XMLUtils.selectElements(doc, "//table/data/row")) {
                SourceData sourceData = new SourceData();
                sourceData.setId(Utils.parseInt(item.getAttribute("f0")));
                sourceData.setSourceTitle(item.getAttribute("f1"));
                sourceData.setPeriod(item.getAttribute("f2"));
                sourceData.setComment(item.getAttribute("f3"));
                list.add(sourceData);
            }
            this.sourceTableModel.setData(list);
        }
    }

    @Override
    public void newItem() {
        this.sourceEditor.init(this.module, this.getModuleId());
        this.sourceEditor.setId(0);
        this.sourceEditor.trySetData();
        this.sourceEditor.setVisible(true);
    }

    @Override
    public void editItem() {
        SourceData sourceData = (SourceData)this.sourceTableModel.getSelectedRow();
        if (sourceData == null) {
            return;
        }
        this.id = sourceData.getId();
        this.sourceEditor.init(this.module, this.getModuleId());
        this.sourceEditor.setId(this.id);
        this.sourceEditor.trySetData();
        this.sourceEditor.setVisible(true);
    }

    @Override
    public void deleteItem() {
        SourceData sourceData = (SourceData)this.sourceTableModel.getSelectedRow();
        if (sourceData == null) {
            return;
        }
        this.id = sourceData.getId();
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request().setModule("load").setAction("DeleteSource").setAttribute("id", this.id).setModuleId(this.getModuleId());
            ClientUtils.checkStatus(this.getDocument(request));
            this.trySetData();
        }
    }

    private void editor_componentHidden(ComponentEvent e) {
        this.trySetData();
    }

    class SourceTableModel
    extends BGTableModel<SourceData> {
        public SourceTableModel() {
            super(SourceTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430", 200, 200, 200, "sourceTitle", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public static class SourceData {
        private int id;
        private String sourceTitle;
        private String period;
        private String comment;

        public int getId() {
            return this.id;
        }

        public String getSourceTitle() {
            return this.sourceTitle;
        }

        public String getPeriod() {
            return this.period;
        }

        public String getComment() {
            return this.comment;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setSourceTitle(String sourceTitle) {
            this.sourceTitle = sourceTitle;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

