/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.common.bean;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.enums.CardPacketStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdContractId;

public class CardPacket
extends IdContractId {
    private int usercardId;
    private Date date1;
    private Date date2;
    private int packetId;
    private String comment = "";
    private CardPacketStatus status = CardPacketStatus.STATUS_ACTIVE;
    private String packetTitle;
    private long cardNumber;
    private Calendar change_date;
    private BigDecimal cost;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getDateFrom() {
        return this.date1;
    }

    public void setDateFrom(Date date1) {
        this.date1 = date1;
    }

    public Date getDateTo() {
        return this.date2;
    }

    public void setDateTo(Date date2) {
        this.date2 = date2;
    }

    public int getPacketId() {
        return this.packetId;
    }

    public void setPacketId(int packetId) {
        this.packetId = packetId;
    }

    public int getUsercardId() {
        return this.usercardId;
    }

    public void setUsercardId(int usercardId) {
        this.usercardId = usercardId;
    }

    public CardPacket setContractId(int contractId) {
        super.setContractId(contractId);
        return this;
    }

    public CardPacketStatus getStatus() {
        return this.status;
    }

    public void setStatus(CardPacketStatus status) {
        this.status = status;
    }

    public String getStringStatus() {
        return Optional.ofNullable(this.status).map(a -> a.getTitle()).orElse("???");
    }

    public String toString() {
        return "CardPacket [id:" + this.getId() + "; contractId:" + this.getContractId() + "; usercardId:" + this.usercardId + "; packetId:" + this.packetId + "; date1-date2:" + TimeUtils.formatPeriod((Date)this.date1, (Date)this.date2) + "; comment:" + this.comment + "]";
    }

    public String getPacketTitle() {
        return this.packetTitle;
    }

    public void setPacketTitle(String packetTitle) {
        this.packetTitle = packetTitle;
    }

    public long getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(long cardNumber) {
        this.cardNumber = cardNumber;
    }

    public Calendar getChange_date() {
        return this.change_date;
    }

    public void setChange_date(Calendar change_date) {
        this.change_date = change_date;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public static class CardPacketComparator
    implements Comparator<CardPacket> {
        @Override
        public int compare(CardPacket o1, CardPacket o2) {
            int cmp = Integer.compare(o1.packetId, o2.packetId);
            if (cmp == 0 && (cmp = o1.date1.compareTo(o2.date1)) == 0) {
                if (o1.date2 == null && o2.date2 == null) {
                    return 0;
                }
                if (o1.date2 != null && o2.date2 == null) {
                    return 1;
                }
                if (o1.date2 == null && o2.date2 != null) {
                    return -1;
                }
                cmp = o1.date2.compareTo(o2.date2);
                if (cmp == 0) {
                    cmp = Integer.compare(o1.status.getCode(), o2.status.getCode());
                }
            }
            return cmp;
        }
    }
}

