/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import jakarta.xml.bind.annotation.XmlType;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.common.model.ContractId;

@XmlType(name="Card", namespace="http://ws.card.services.module.billing.bitel")
public class Card
extends ContractId {
    public static final int CARD_LOCK = 0;
    public static final int CARD_ACTIVE = 1;
    public static final int CARD_ACTIVATE_CONTRACT = 2;
    public static final int CARD_ACTIVATE_BALANCE = 3;
    public static final int TYPE_CURRENT_DB = 1;
    public static final int TYPE_SUPER_DB = 2;
    private int type = 1;
    private int moduleId = -1;
    private long id = -1L;
    private int seriesId;
    private long cardCode = -1L;
    private String cardPinCode = null;
    private int dealerId;
    private Date dealerDate;
    private float summa = 0.0f;
    private Date dateBegin = null;
    private Date dateEnd = null;
    private int status = 0;
    private int servicePayId = -1;
    private Date dateActivate = null;
    private int payment_type = -1;
    private int patternId = -1;
    private int serviceActivateId = -1;

    public String getCardPinCode() {
        return this.cardPinCode;
    }

    public boolean checkPinCode(String value) {
        return value == null || this.getCardPinCode() == null ? false : value.equals(this.getCardPinCode());
    }

    public Card setId(long value) {
        this.id = value;
        return this;
    }

    public long getId() {
        return this.id;
    }

    public Card setCardCode(long value) {
        this.cardCode = value;
        return this;
    }

    public long getCardCode() {
        return this.cardCode;
    }

    public Card setCardPinCode(String value) {
        this.cardPinCode = value;
        return this;
    }

    public Card setSumma(float value) {
        this.summa = value;
        return this;
    }

    public float getSumma() {
        return this.summa;
    }

    public Card setDateBegin(Date value) {
        this.dateBegin = value;
        return this;
    }

    public Date getDateBegin() {
        return this.dateBegin;
    }

    public Card setDateEnd(Date value) {
        this.dateEnd = value;
        return this;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public Card setStatus(int value) {
        this.status = value;
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public Card setServicePayId(int servicePayId) {
        this.servicePayId = servicePayId;
        return this;
    }

    public int getServicePayId() {
        return this.servicePayId;
    }

    public Card setContractId(int contractId) {
        super.setContractId(contractId);
        return this;
    }

    public Card setDateActivate(Date value) {
        this.dateActivate = value;
        return this;
    }

    public Date getDateActivate() {
        return this.dateActivate;
    }

    public boolean checkPeriod(Date value) {
        return value != null && this.dateBegin != null && !this.dateBegin.after(value) && this.dateEnd != null && !value.after(this.dateEnd);
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        return new StringBuffer().append("card [ id = ").append(this.getId()).append("; code = ").append(this.getCardCode()).append("; pinCode = ").append(this.cardPinCode).append("; summa = ").append(this.getSumma()).append("; dateBegin = ").append(this.getDateBegin() == null ? "" : sdf.format(this.getDateBegin())).append("; dateEnd = ").append(this.getDateEnd() == null ? "" : sdf.format(this.getDateEnd())).append("; status = ").append(this.getStatus()).append("; sid_pay = ").append(this.servicePayId).append("; sid_act = ").append(this.serviceActivateId).append("; contractID = ").append(this.getContractId()).append("; dateActivate = ").append(this.getDateActivate() == null ? "" : sdf.format(this.getDateActivate())).append(" ]").toString();
    }

    public int getPatternId() {
        return this.patternId;
    }

    public Card setPatternId(int value) {
        this.patternId = value;
        return this;
    }

    public Card setPaymentType(int value) {
        this.payment_type = value;
        return this;
    }

    public int getPaymentType() {
        return this.payment_type;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public Card setModuleId(int moduleId) {
        this.moduleId = moduleId;
        return this;
    }

    public int getServiceActivateId() {
        return this.serviceActivateId;
    }

    public Card setServiceActivateId(int serviceActivateId) {
        this.serviceActivateId = serviceActivateId;
        return this;
    }

    public String getContractName(Calendar time) {
        SimpleDateFormat sdf_1 = new SimpleDateFormat("yy");
        StringBuffer title = new StringBuffer("K");
        if (this.getCardCode() < 10L) {
            title.append('0');
        }
        if (this.getCardCode() < 100L) {
            title.append('0');
        }
        if (this.getCardCode() < 1000L) {
            title.append('0');
        }
        if (this.getCardCode() < 10000L) {
            title.append('0');
        }
        title.append(this.getCardCode());
        title.append('-');
        title.append(sdf_1.format(time.getTime()));
        return title.toString();
    }

    public int getDealerId() {
        return this.dealerId;
    }

    public Card setDealerId(int dealerId) {
        this.dealerId = dealerId;
        return this;
    }

    public int getType() {
        return this.type;
    }

    public Card setType(int type) {
        this.type = type;
        return this;
    }

    public Date getDealerDate() {
        return this.dealerDate;
    }

    public Card setDealerDate(Date dealerDate) {
        this.dealerDate = dealerDate;
        return this;
    }

    public int getSeriesId() {
        return this.seriesId;
    }

    public Card setSeriesId(int seriesId) {
        this.seriesId = seriesId;
        return this;
    }
}

