/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotDialogConfigurePanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.ExportImport;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.list.BGUList;

public class BotImportDialog
extends ExportImport {
    private BGUList<BotDialog> listForInsertImportedDialog;
    private JSONObject importJSONData;
    private BotDialog dialogForImport;

    protected BotImportDialog(BotDialogConfigurePanel parentPanel, BGUList<BotDialog> listForInsertImportedDialog) {
        super(parentPanel, "\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u0438\u0430\u043b\u043e\u0433\u0430", "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.listForInsertImportedDialog = listForInsertImportedDialog;
    }

    @Override
    protected void configurateFileChooser(JFileChooser fileChooser) {
        fileChooser.setFileSelectionMode(0);
    }

    @Override
    protected void process(JFileChooser fileChooser) throws BGException {
        File file = fileChooser.getSelectedFile();
        if (file == null || !file.exists()) {
            return;
        }
        try {
            String data = new String(Files.readAllBytes(file.toPath()), "UTF-8");
            this.importJSONData = new JSONObject(data);
            this.dialogForImport = this.convertJsonToBotDialog(this.importJSONData);
            this.showConfirmDialog();
        }
        catch (IOException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private BotDialog convertJsonToBotDialog(JSONObject json) {
        BotDialog dialog = new BotDialog();
        dialog.setTitle(json.optString("title", ""));
        dialog.setOnlySignedUser(json.optBoolean("onlySignedUser", false));
        dialog.setDialogElements(this.getDialogElements(json));
        dialog.setProcessingClass(json.optString("processingClassName", ""));
        return dialog;
    }

    private List<BotDialogElement> getDialogElements(JSONObject json) {
        ArrayList<BotDialogElement> dialogElements = new ArrayList<BotDialogElement>();
        JSONArray elements = json.optJSONArray("elements");
        if (elements != null && elements.length() > 0) {
            for (int i = 0; i < elements.length(); ++i) {
                JSONObject element = elements.optJSONObject(i);
                BotDialogElement dialogElement = new BotDialogElement();
                dialogElement.setElementType(BotDialogElementType.getElementType((int)element.optInt("elementType", 0)));
                dialogElement.setConfigElement(element.optString("config"));
                dialogElements.add(dialogElement);
            }
        }
        return dialogElements;
    }

    private void showConfirmDialog() {
        BGDialog confirmDialog = new BGDialog(null, "\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u0438\u0430\u043b\u043e\u0433\u0430 \u043f\u0435\u0440\u0435\u0434 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\u043c", Dialog.ModalityType.APPLICATION_MODAL);
        confirmDialog.setSize(new Dimension(600, 300));
        confirmDialog.moveWindowToCenterScreen();
        confirmDialog.getContentPane().setLayout(new GridBagLayout());
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: ").append(this.dialogForImport.getTitle()).append("<br>").append("\u0412\u0441\u0435\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432: ").append(this.dialogForImport.getDialogElements().size()).append("<br>").append("\u041a\u043b\u0430\u0441\u0441 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438: ").append(this.dialogForImport.getProcessingClass()).append("</html>");
        JLabel dialogInfoLabel = new JLabel(sb.toString());
        dialogInfoLabel.setFont(new Font("SansSerif", 0, 13));
        confirmDialog.getContentPane().add((Component)dialogInfoLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.getButtonOk().addActionListener(e -> {
            try {
                this.saveDialog();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            confirmDialog.dispose();
        });
        okCancel.getButton(BGButtonPanelOkCancel.CANCEL).addActionListener(e -> confirmDialog.dispose());
        confirmDialog.getContentPane().add((Component)okCancel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(3, 3, 3, 3), 0, 0));
        confirmDialog.showDialog();
    }

    private void saveDialog() throws Exception {
        for (BotDialogElement element : this.dialogForImport.getDialogElements()) {
            int insertId = this.botManagerService.updateDialogElement(element);
            element.setId(insertId);
        }
        if (this.dialogForImport.getDialogElements().stream().anyMatch(d -> d.getId() <= 0)) {
            System.out.println("\u0410\u0445\u0442\u0443\u043d\u0433!! \u043d\u0435\u0442 id\u0448\u043d\u0438\u043a\u043e\u0432 \u0434\u043b\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0434\u0438\u0430\u043b\u043e\u0433\u0430");
            return;
        }
        String processingClassPath = this.putProcessingClassToDynamicCode(this.importJSONData);
        if (Utils.notBlankString((String)processingClassPath)) {
            this.dialogForImport.setProcessingClass(processingClassPath);
        }
        this.botManagerService.updateDialog(this.dialogForImport);
        this.listForInsertImportedDialog.setData(this.botManagerService.getDialogs());
    }

    private String putProcessingClassToDynamicCode(JSONObject json) throws UnsupportedEncodingException {
        String source = json.optString("processingClass", "");
        String className = json.optString("processingClassName", "");
        if (Utils.isBlankString((String)source) || Utils.isBlankString((String)className)) {
            return "";
        }
        try {
            this.dynamicCodeService.updateSource(className, source);
            this.dynamicCodeService.compile(className);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        return className;
    }
}

