/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.tariff;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanelEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class CallCostTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"coin");
    private JLabel view = new JLabel(icon, 2);
    private ButtonGroup buttonGroup = new ButtonGroup();
    private BGFloatTextField cost = new BGFloatTextField(10);
    private BGIntTextField count = new BGIntTextField();
    private JCheckBox defaultPrice = new JCheckBox("\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
    private BGUComboBox<TariffVar> tariffVars = new BGUComboBox();
    private BGUComboBox<KeyValue> costDivisorCombo = new BGUComboBox();
    private String costValue;
    private String countValue;
    private boolean isDefault;
    private String costSource;
    private String costDivisor;
    private List<KeyValue> costDivisors = Arrays.asList(new KeyValue("1", "\u0441\u0435\u043a\u0443\u043d\u0434"), new KeyValue("60", "\u043c\u0438\u043d\u0443\u0442"), new KeyValue("3600", "\u0447\u0430\u0441"));

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        try {
            if (tree.getParent() instanceof TariffPanelEditor) {
                this.vars.add(TariffVar.from((IdTitle)IdTitle.NO_SELECT));
                int moduleId = this.getModuleId(parent);
                TariffPanelEditor tariffPanelEditor = (TariffPanelEditor)tree.getParent();
                this.vars.addAll(tariffPanelEditor.getTariffService().tariffVars(TariffVarType.COST, Arrays.asList(tariffPanelEditor.getTariffPlanId(), 0)).stream().filter(a -> a.getModuleId() == moduleId || a.getModuleId() == 0).toList());
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected void loadData() {
        this.extractData();
        this.buttonGroup.getElements().asIterator().forEachRemaining(a -> a.setSelected(a.getActionCommand().equals(this.costSource)));
        this.cost.setText(this.costValue);
        this.count.setText(this.countValue);
        this.defaultPrice.setSelected(this.isDefault);
        this.costDivisorCombo.setData(this.costDivisors);
        this.costDivisorCombo.setSelectedItem((Object)this.costDivisors.stream().filter(a -> a.getKey().equals(this.costDivisor)).findFirst().orElse(this.costDivisors.get(0)));
        this.tariffVars.setData(this.vars);
        this.tariffVars.setSelectedItem((Object)this.tariffVar);
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.costValue = (String)data.get("cost");
        if (this.costValue == null) {
            this.costValue = "";
        }
        this.isDefault = data.get("default") != null;
        this.costDivisor = (String)data.get("cost_divisor");
        if (Utils.isBlankString((String)this.costDivisor)) {
            this.costDivisor = "60";
        }
        this.costSource = (String)data.get("cost_source");
        if (Utils.isBlankString((String)this.costSource)) {
            this.costSource = "node";
        }
        if (data.size() == 0) {
            this.costValue = this.getData();
            this.isDefault = false;
            this.costDivisor = "60";
            this.costSource = "node";
        }
        this.countValue = (String)data.get("count");
        int tariffVarId = Utils.parseInt((String)data.getOrDefault("tariffVarId", "0"), (int)0);
        this.tariffVar = this.vars.isEmpty() ? null : this.vars.stream().filter(a -> a.getId() == tariffVarId || a.getTopId() == tariffVarId).findFirst().orElse((TariffVar)this.vars.get(0));
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cost", this.cost.getText());
        data.put("count", this.count.getText());
        if (this.defaultPrice.isSelected()) {
            data.put("default", "true");
        }
        data.put("cost_divisor", ((KeyValue)this.costDivisorCombo.getSelectedItem()).getKey());
        data.put("cost_source", this.buttonGroup.getSelection().getActionCommand());
        data.put("tariffVarId", String.valueOf(this.tariffVars.getSelectedItem() != null ? ((TariffVar)this.tariffVars.getSelectedItem()).getId() : 0));
        this.setDataInHash(data);
    }

    public void loadFromXML(Element element) {
        this.loadHashFromXML(element);
    }

    public void serializeToXML(Element element) {
        this.serializeHashToXML(element);
    }

    protected JPanel getEditorPanel() {
        JRadioButton costFromConstant = new JRadioButton("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u044b", true);
        costFromConstant.setActionCommand("node");
        this.buttonGroup.add(costFromConstant);
        JRadioButton costFromCostMap = new JRadioButton("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d");
        costFromCostMap.setActionCommand("costMap");
        this.buttonGroup.add(costFromCostMap);
        JRadioButton costFromCDR = new JRadioButton("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 CDR");
        costFromCDR.setActionCommand("cdr");
        this.buttonGroup.add(costFromCDR);
        JRadioButton costFromTariffVar = new JRadioButton("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0438\u0437 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
        costFromTariffVar.setActionCommand("tariffVar");
        this.buttonGroup.add(costFromTariffVar);
        JPanel propsPanel = new JPanel(new GridBagLayout());
        propsPanel.add((Component)costFromConstant, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        propsPanel.add((Component)this.cost, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 0, 10), 0, 0));
        propsPanel.add((Component)costFromCostMap, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        propsPanel.add((Component)costFromCDR, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        propsPanel.add((Component)costFromTariffVar, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        propsPanel.add((Component)this.tariffVars, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 0, 10), 0, 0));
        propsPanel.add((Component)this.getCostCountPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 25, 0, 0), 0, 0));
        propsPanel.add((Component)this.defaultPrice, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 25, 0, 0), 0, 0));
        return propsPanel;
    }

    private JPanel getCostCountPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0437\u0430 "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.count, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.costDivisorCombo, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public Component getView() {
        this.extractData();
        StringBuilder labelText = new StringBuilder(100);
        labelText.append(this.getLabelTitle());
        if (this.costSource.equals("cdr")) {
            labelText.append(" \u0432\u0437\u044f\u0442\u044c \u0438\u0437 CDR");
        } else {
            labelText.append(" " + this.countValue);
            switch (this.costDivisor) {
                case "1": {
                    labelText.append(" \u0441\u0435\u043a\u0443\u043d\u0434\u044b");
                    break;
                }
                case "60": {
                    labelText.append(" \u043c\u0438\u043d\u0443\u0442\u044b");
                    break;
                }
                case "3600": {
                    labelText.append(" \u0447\u0430\u0441\u0430");
                }
            }
            if (this.costSource.equals("costMap")) {
                labelText.append(" \u0432\u0437\u044f\u0442\u044c \u0438\u0437 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d");
            } else if (this.costSource.equals("node")) {
                labelText.append(" = ");
                labelText.append(this.costValue);
            } else if (this.costSource.equals("tariffVar")) {
                labelText.append(" \u0432\u0437\u044f\u0442\u044c \u0438\u0437 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 ").append((String)(this.tariffVar != null ? "< " + this.tariffVar.getTitle() + " [" + this.getTariffVarValue(this.tariffVar) + "] >" : "???"));
            }
            if (this.isDefault) {
                labelText.append(" *");
            }
        }
        this.view.setText(labelText.toString());
        return this.view;
    }

    protected String getLabelTitle() {
        return "\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c";
    }

    protected void editOk() {
        if ("tariffVar".equals(this.buttonGroup.getSelection().getActionCommand()) && ((TariffVar)this.tariffVars.getSelectedItem()).getId() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
            return;
        }
        super.editOk();
    }
}

