/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.voice.accounting.recalculate.VoiceRecalculator;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventProcessorException;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.log.server.event.RequestLogGetEvent;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.voice.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAuthError;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceError;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceErrorFilter;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicRange;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOption;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceProcessLog;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceOptionModifiedEvent;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.bgbilling.modules.voice.server.bean.DataProccessRecordDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAuthErrorDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDestinationDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceErrorDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceOptionDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceProcessLogDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.GeoCodeManager;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceGeographicCodeDao;
import ru.bitel.bgbilling.modules.voice.server.bean.range.VoiceGeographicRangeDao;
import ru.bitel.bgbilling.modules.voice.server.event.GeoCodeUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.event.RequestLogInfoEvent;
import ru.bitel.bgbilling.modules.voice.server.event.RequestRadiusLogInfoEvent;
import ru.bitel.bgbilling.modules.voice.server.task.VoiceBalanceSetter;
import ru.bitel.bgbilling.modules.voice.server.utils.VoiceUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Node;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceService")
public class VoiceServiceImpl
extends AbstractService
implements VoiceService {
    private VoiceOptionDao voiceOptionDao;
    private VoiceProcessLogDao voiceProcessLogDao;
    private VoiceDestinationDao voiceDestinationDao;
    private DataProccessRecordDao dataProcessRecordDao;
    private VoiceGeographicCodeDao voiceGeographicCodeDao;
    private VoiceGeographicRangeDao voiceGeographicRangeDao;

    @PostConstruct
    private void init() {
        this.voiceOptionDao = new VoiceOptionDao(this.getConnection(), this.moduleId);
        this.voiceProcessLogDao = new VoiceProcessLogDao(this.getConnection(), this.moduleId);
        this.voiceDestinationDao = new VoiceDestinationDao(this.getConnection(), this.moduleId);
        this.dataProcessRecordDao = new DataProccessRecordDao(this.getConnection(), this.moduleId);
        this.voiceGeographicCodeDao = new VoiceGeographicCodeDao(this.getConnection(), this.moduleId);
        this.voiceGeographicRangeDao = new VoiceGeographicRangeDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<VoiceDestination> voiceDestinationList(int operator, String title, Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(page);
            this.voiceDestinationDao.searchDestination((SearchResult<VoiceDestination>)searchResult, operator, title, true);
            return searchResult;
        });
    }

    public List<IdTitle> voiceDestinationTitles(List<Integer> destIds) throws BGException {
        return (List)this.tryReturn(() -> this.voiceDestinationDao.list(destIds));
    }

    public VoiceDestination voiceDestinationGet(int id) throws BGException {
        return (VoiceDestination)this.tryReturn(() -> (VoiceDestination)this.voiceDestinationDao.get(id));
    }

    public int voiceDestinationUpdate(VoiceDestination destination) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.voiceDestinationDao.update(destination);
            return destination.getId();
        });
    }

    public int voiceDestinationDelete(List<Integer> idSet) throws BGException {
        return (Integer)this.tryReturn(() -> this.voiceDestinationDao.delete(idSet));
    }

    public void voiceDestinationReplace(int sourceDestinationId, int targetDestinationId) throws BGException {
        this.tryCall(() -> this.voiceGeographicCodeDao.replaceDestination(sourceDestinationId, targetDestinationId));
    }

    public String getGeographicCodeTree(int operatorId) throws BGException {
        return (String)this.tryReturn(() -> {
            GeoCodeManager codeDao = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);
            List<VoiceGeographicCode> codeList = codeDao.list(-1, operatorId);
            return Base64.getEncoder().encodeToString(this.listToTreeRoot(codeList));
        });
    }

    public List<IdTitle> voiceGeographicCodeTitles(int operatorId) throws BGException {
        return (List)this.tryReturn(() -> new GeoCodeManager(this.getConnection(), this.moduleId, this.userId).list(-1, operatorId).stream().map(a -> new IdTitle(a.getId(), a.getCode() + " - " + a.getDestinationTitle())).toList());
    }

    public int updateGeographicCode(VoiceGeographicCode code) throws BGException {
        return new GeoCodeManager(this.getConnection(), this.moduleId, this.userId).updateGeographicCode(code);
    }

    public int deleteGeographicCode(List<Integer> codes) throws BGException {
        return (Integer)this.tryReturn(() -> {
            EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
            return new GeoCodeManager(this.getConnection(), this.moduleId, this.userId).delete(codes);
        });
    }

    public String importGeographicCode(int operatorId, boolean addNew, boolean updateExist, String importContent) throws BGException {
        return new GeoCodeManager(this.getConnection(), this.moduleId, this.userId).importGeographicCode(operatorId, addNew, updateExist, importContent);
    }

    public void deleteAllGeographicCode(int operatorId) throws BGException {
        this.tryCall(() -> {
            GeoCodeManager codeDao = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);
            codeDao.delete(codeDao.list(-1, operatorId).stream().map(item -> item.getId()).toList());
        });
    }

    private byte[] listToTreeRoot(List<VoiceGeographicCode> codeList) throws BGException {
        return (byte[])this.tryReturn(() -> {
            VoiceUtils.fillParents(codeList);
            VoiceGeographicCode root = new VoiceGeographicCode(0, "\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432");
            root = (VoiceGeographicCode)TreeUtils.tree((List)codeList, (Node)root);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.writeObject(root);
                    oos.flush();
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
        });
    }

    public List<VoiceGeographicCode> voiceGeographicCodeByDestinationId(int destinationId) throws BGException {
        return this.voiceGeographicCodeDao.getVoiceGeographicCodeByDestinationId(destinationId);
    }

    public void calculate(Date dateFrom, Date dateTo, Set<Integer> contractIds, long groupMask, String email, String comment) throws BGException {
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new VoiceRecalculator(dateFrom, dateTo, contractIds, groupMask, email, comment, this.moduleId));
    }

    public void setBalance(Date month, String email, Set<Integer> contractIds) throws BGException {
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new VoiceBalanceSetter(this.moduleId, month, email, contractIds));
    }

    public String voiceGeographicRangeList(int operatorId) throws BGException {
        return (String)this.tryReturn(() -> {
            List<VoiceGeographicRange> list = this.voiceGeographicRangeDao.list(operatorId);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                String string;
                try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.writeObject(list);
                    oos.flush();
                    string = Base64.getEncoder().encodeToString(baos.toByteArray());
                }
                return string;
            }
        });
    }

    public VoiceGeographicRange voiceGeographicRangeGet(int id) throws BGException {
        return null;
    }

    public int voiceGeographicRangeUpdate(VoiceGeographicRange range) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.voiceGeographicRangeDao.update(range);
            return range.getId();
        });
    }

    public void voiceGeographicRangeDelete(List<Integer> ids) throws BGException {
        this.tryCall(() -> {
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                this.voiceGeographicRangeDao.delete(id);
            }
        });
    }

    public String voiceGeographicRangeImport(int operatorId, String importData, boolean addDestination) throws BGException {
        return (String)this.tryReturn(() -> {
            VoiceGeographicRangeDao rangeDao = new VoiceGeographicRangeDao(this.getConnection(), this.moduleId);
            Map<String, VoiceDestination> destinationMap = this.voiceDestinationDao.titleMap(operatorId);
            StringBuilder res = new StringBuilder();
            VoiceGeographicRange range = new VoiceGeographicRange();
            range.setOperatorId(operatorId);
            for (String data : importData.split("\n")) {
                range.setId(0);
                range.setMobileId("");
                String[] a = data.split("\t");
                VoiceDestination voiceDestination = destinationMap.get(a[2]);
                if (voiceDestination == null) {
                    if (addDestination) {
                        voiceDestination = new VoiceDestination();
                        voiceDestination.setOperatorId(operatorId);
                        voiceDestination.setTitle(a[2]);
                        this.voiceDestinationDao.update(voiceDestination);
                        destinationMap.put(a[2], voiceDestination);
                    } else {
                        res.append(data).append(" <== \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435\n");
                        continue;
                    }
                }
                if (a.length > 2) {
                    range.setRangeFrom(Utils.parseLong((String)a[0]));
                    range.setRangeTo(Utils.parseLong((String)a[1]));
                    range.setDestinationId(voiceDestination.getId());
                }
                if (a.length > 3) {
                    range.setMobileId(a[4]);
                }
                if (range.getRangeFrom() > range.getRangeTo()) {
                    res.append(data).append(" <== \u043d\u0430\u0447\u0430\u043b\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f\n");
                    continue;
                }
                if (range.getRangeFrom() < 10000000000L) {
                    res.append(data).append(" <== \u043d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u043d\u044c\u0448\u0435 11 \u0446\u0438\u0444\u0440\n");
                    continue;
                }
                if (range.getRangeTo() < 10000000000L) {
                    res.append(data).append(" <== \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043c\u0435\u043d\u044c\u0448\u0435 11 \u0446\u0438\u0444\u0440\n");
                    continue;
                }
                rangeDao.update(range);
            }
            return res.toString();
        });
    }

    public List<VoiceGeographicRange> voiceGeographicRangeSearch(int operatorId, String txt) throws BGException {
        return (List)this.tryReturn(() -> this.voiceGeographicRangeDao.list(operatorId, txt));
    }

    public List<VoiceGeographicRange> voiceGeographicRanges(List<Integer> rangeIds) throws BGException {
        return (List)this.tryReturn(() -> this.voiceGeographicRangeDao.list(rangeIds));
    }

    public String voiceConnectionLog(int deviceId, long sessionId, Date connectionStartTime, boolean finished) throws BGException {
        try (VoiceSessionLogDao sessionDao = finished ? new VoiceSessionLogDao(this.getConnectionSet().getConnection(), this.moduleId, connectionStartTime) : new VoiceSessionDao(this.getConnectionSet().getConnection(), this.moduleId);){
            RequestLogGetEvent event;
            ConnectionLogEntryDao dataLogEntryDao;
            block18: {
                List entries;
                block17: {
                    String string;
                    VoiceSession session = sessionDao.get(sessionId);
                    if (session == null) {
                        String string2 = "\u0421\u0435\u0441\u0441\u0438\u044f:" + sessionId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
                        return string2;
                    }
                    dataLogEntryDao = new ConnectionLogEntryDao(this.getConnectionSet(), this.moduleId);
                    try {
                        entries = dataLogEntryDao.list(session.getSessionStart(), session.getSessionStop(), deviceId, 0, null, session.getId(), session.getIdentifier());
                        if (entries.size() != 0) break block17;
                        string = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u043b\u043e\u0433\u0430.";
                    }
                    catch (Throwable throwable) {
                        try {
                            dataLogEntryDao.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    dataLogEntryDao.close();
                    return string;
                }
                int applicationId = ((ConnectionLogEntry)entries.get(0)).getApplicationId();
                event = new RequestLogGetEvent(this.moduleId, deviceId, applicationId, entries);
                event = (RequestLogGetEvent)EventProcessor.getInstance().request((Event)event, 10000L);
                if (event != null) break block18;
                String string = "C\u0435\u0440\u0432\u0435\u0440 \u043b\u043e\u0433\u043e\u0432 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
                dataLogEntryDao.close();
                return string;
            }
            String string = this.getTextLog(event);
            dataLogEntryDao.close();
            return string;
        }
    }

    public String authErrorLog(int deviceId, Date errorTime, int logCoordinateRecordId) throws BGException {
        try (ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(this.getConnectionSet(), this.moduleId);){
            ConnectionLogEntry entry = dataLogEntryDao.get(deviceId, errorTime, logCoordinateRecordId);
            if (entry == null) {
                String string = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430 \u043b\u043e\u0433\u0430.";
                return string;
            }
            RequestLogGetEvent event = new RequestLogGetEvent(this.moduleId, deviceId, entry);
            event = (RequestLogGetEvent)EventProcessor.getInstance().request((Event)event, 10000L);
            if (event == null) {
                String string = "C\u0435\u0440\u0432\u0435\u0440 \u043b\u043e\u0433\u043e\u0432 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
                return string;
            }
            String string = this.getTextLog(event);
            return string;
        }
    }

    protected String getTextLog(RequestLogGetEvent event) throws EventProcessorException {
        StringBuilder result = new StringBuilder(1000);
        if (event.getLogEntryResultList() != null) {
            for (RequestLogGetEvent.LogEntryResult entryResult : event.getLogEntryResultList()) {
                result.append("Time: ").append(TimeUtils.format((Date)new Date(entryResult.getMillis()), (String)"dd.MM.yyyy HH:mm:ss")).append("\n");
                result.append(entryResult != null ? entryResult.getData() : "null");
                result.append("\n");
            }
        }
        return result.toString();
    }

    public VoiceOption voiceOptionGet(int id) throws BGException {
        return (VoiceOption)this.voiceOptionDao.get(id);
    }

    public List<VoiceOption> voiceOptionList() throws BGException {
        return this.voiceOptionDao.list();
    }

    public int voiceOptionUpdate(VoiceOption b) throws BGException {
        return (Integer)this.tryReturn(() -> {
            VoiceOption oldOption = (VoiceOption)this.voiceOptionDao.getAndUpdate((Id)b);
            this.context.publishAfterCommit((Event)new VoiceOptionModifiedEvent(this.moduleId, this.userId, oldOption, b));
            return b.getId();
        });
    }

    public void voiceOptionDelete(int id) throws BGException {
        this.tryCall(() -> {
            VoiceOption oldOption = (VoiceOption)this.voiceOptionDao.getAndDelete(id);
            this.context.publishAfterCommit((Event)new VoiceOptionModifiedEvent(this.moduleId, this.userId, oldOption, null));
        });
    }

    public Result<VoiceAuthError> authErrorDateList(Date timeFrom, Date timeTo, Set<Integer> deviceIds, Set<Integer> contractIds, Set<Integer> serviceIds, String contract, String login, Page page) throws BGException {
        return (Result)this.tryReturn(() -> new VoiceAuthErrorDao(this.getConnectionSet(), this.moduleId, timeFrom).errorList(timeFrom, timeTo, deviceIds, contractIds, serviceIds, contract, login, page));
    }

    public Result<VoiceError> voiceErrorList(VoiceErrorFilter filter, Page page) throws BGException {
        return (Result)this.tryReturn(() -> {
            VoiceErrorDao voiceErrorDao = new VoiceErrorDao(this.getConnectionSet(), this.moduleId, filter.getDateFrom());
            VoiceErrorDao.checkTables(this.getConnectionSet().getConnection(), this.moduleId, filter.getDateFrom());
            return voiceErrorDao.list(filter, page);
        });
    }

    public Result<?> voiceLogExist(Integer deviceId, Date month) throws BGException {
        Result result = new Result();
        int[] exists = this.getLogExists(deviceId, month);
        if (exists != null) {
            result.setAttribute("logExists", (Object)exists);
        }
        return result;
    }

    public Result<?> voiceRadiusLogExist(Integer deviceId, Date month) throws BGException {
        Result result = new Result();
        int[] exists = this.getRadisLogExists(deviceId, month);
        if (exists != null) {
            result.setAttribute("logExists", (Object)exists);
        }
        return result;
    }

    public List<DataProcessRecord> voiceLogLoading(Integer deviceId, Date month) throws BGException {
        Calendar cal = new GregorianCalendar();
        cal.setTime(month);
        cal = TimeUtils.getStartMonth((Calendar)cal);
        cal.set(5, 1);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)cal);
        Date dateFrom = TimeUtils.convertCalendarToDate((Calendar)cal);
        cal.add(2, 1);
        Date dateTo = TimeUtils.convertCalendarToDate((Calendar)cal);
        return this.dataProcessRecordDao.list(deviceId, dateFrom, dateTo);
    }

    public List<VoiceProcessLog> voiceLogLoaded(Integer deviceId, Date month) throws BGException {
        Calendar cal = new GregorianCalendar();
        cal.setTime(month);
        cal = TimeUtils.getStartMonth((Calendar)cal);
        cal.set(5, 1);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)cal);
        Date dateFrom = TimeUtils.convertCalendarToDate((Calendar)cal);
        cal.add(2, 1);
        Date dateTo = TimeUtils.convertCalendarToDate((Calendar)cal);
        return this.voiceProcessLogDao.list(deviceId, dateFrom, dateTo);
    }

    protected int[] getLogExists(Integer deviceId, Date month) throws BGException {
        int[] exists = null;
        RequestLogInfoEvent event = new RequestLogInfoEvent(this.moduleId, month, deviceId);
        event = (RequestLogInfoEvent)EventProcessor.getInstance().request((Event)event, 5000L);
        if (event != null) {
            exists = event.getLogs();
        }
        return exists;
    }

    protected int[] getRadisLogExists(Integer deviceId, Date month) throws BGException {
        int[] exists = null;
        RequestLogInfoEvent event = new RequestRadiusLogInfoEvent(this.moduleId, month, deviceId);
        event = (RequestLogInfoEvent)EventProcessor.getInstance().request((Event)event, 5000L);
        if (event != null) {
            exists = event.getLogs();
        }
        return exists;
    }

    public void voiceAddProcessLogs(Integer deviceId, List<Date> days) throws BGException {
        this.addTasks(deviceId, days, false);
    }

    public void voiceAddRadiusProcessLogs(Integer deviceId, List<Date> days) throws BGException {
        this.addTasks(deviceId, days, true);
    }

    public void addTasks(Integer deviceId, List<Date> days, boolean isRadius) throws BGException {
        this.tryCall(() -> {
            List<DataProcessRecord> list = this.dataProcessRecordDao.list(isRadius);
            for (Date day : days) {
                boolean found = false;
                for (DataProcessRecord record : list) {
                    if (record.getDeviceId() != deviceId.intValue() || !record.getDay().equals(day)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                DataProcessRecord record = new DataProcessRecord().setDeviceId(deviceId.intValue()).setDay(day).setRadius(isRadius);
                this.dataProcessRecordDao.update(record);
            }
        });
    }

    public void voiceDeleteProcessLogs(Integer deviceId, List<Date> hours) throws BGException {
        this.dataProcessRecordDao.delete(deviceId, hours);
    }
}

