/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;

public class TvSearchPanel
extends BGUTabPanel {
    private TvAccountService tvAccountService = null;
    private BGUComboBox<TvAccountSpec> serviceType = new BGUComboBox();
    private BGDataSourceTableModel model = new BGDataSourceTableModel("TvSearch");
    private JTextField searchFieldValue = new JTextField(30);
    private BGUComboBox<KeyValue> searchFields = new BGUComboBox();
    private List<KeyValue> searchFieldItems = Arrays.asList(new KeyValue("login", "\u041b\u043e\u0433\u0438\u043d"), new KeyValue("extId", "ExtID"), new KeyValue("id", "ID"), new KeyValue("identifier", "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440"), new KeyValue("macAddress", "MAC-\u0430\u0434\u0440\u0435\u0441"));

    public TvSearchPanel(ClientContext clientContext) {
        super(clientContext);
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)this.model);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TvAccount tvAccount;
                if (mouseEvent.getClickCount() == 2 && (tvAccount = (TvAccount)TvSearchPanel.this.model.getSelectRow(TvAccount.class)) != null) {
                    ClientUtils.openContract((int)tvAccount.getContractId());
                }
            }
        });
        this.searchFields.setData(this.searchFieldItems);
        this.searchFieldValue.setHorizontalAlignment(0);
        BGButton clearField = new BGButton("X");
        clearField.addActionListener(e -> this.searchFieldValue.setText(""));
        Action find = this.getActionMap().get("find");
        BGButton searchButton = new BGButton(find);
        this.searchFieldValue.setAction(find);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.searchFields, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.searchFieldValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)clearField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u0441\u0435\u0440\u0432\u0438\u0441\u0430"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.serviceType, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)searchButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.addAfterJbInitTask(() -> {
            try {
                List typeList = this.getTvAccountService().tvAccountSpecList();
                typeList.add(0, new TvAccountSpec().setId(0).setTitle("\u041b\u044e\u0431\u043e\u0439"));
                this.serviceType.setData(typeList);
                this.model.loadData((ClientContext)this.getContext(), null);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }));
        new AbstractBGUPanel.DefaultAction("find", "\u041d\u0430\u0439\u0442\u0438"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                KeyValue selectedItem = (KeyValue)TvSearchPanel.this.searchFields.getSelectedItem();
                BGUTableParams tableParams = new BGUTableParams();
                if ("id".equals(selectedItem.getKey()) && Utils.notBlankString((String)TvSearchPanel.this.searchFieldValue.getText())) {
                    int idValue = Utils.parseInt((String)TvSearchPanel.this.searchFieldValue.getText(), (int)-1);
                    if (idValue == -1) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0451\u043d ID!");
                        return;
                    }
                    tableParams.addParam("id", String.valueOf(idValue));
                } else {
                    TvAccountSpec selectedType = (TvAccountSpec)TvSearchPanel.this.serviceType.getSelectedItem();
                    tableParams.addParam("typeId", String.valueOf(selectedType != null ? selectedType.getId() : 0)).addParam("filter_key", selectedItem.getKey()).addParam("filter_value", TvSearchPanel.this.searchFieldValue.getText());
                }
                TvSearchPanel.this.model.loadData((ClientContext)TvSearchPanel.this.getContext(), tableParams);
            }
        };
    }

    private TvAccountService getTvAccountService() {
        if (this.tvAccountService == null) {
            this.tvAccountService = (TvAccountService)((ClientContext)this.getContext()).getPort(TvAccountService.class);
        }
        return this.tvAccountService;
    }
}

