/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rbkmoney.server.action.web;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.rbkmoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.rbkmoney.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.rbkmoney.server.bean.Constants;
import ru.bitel.bgbilling.modules.rbkmoney.server.bean.TransactionManager;
import ru.bitel.common.model.SearchResult;

@WebAction(title="RbkMoney")
public class ActionDoTransaction
extends AbstractPaymentAction {
    private static final String PARAM_AMOUNT = "AMOUNT";
    private static final String PARAM_FAIL_URL = "FAIL_URL";
    private static final String PARAM_ESHOP_ID = "ESHOP_ID";
    private static final String PARAM_ORDER_ID = "ORDER_ID";
    private static final String PARAM_CURRENCY = "CURRENCY";
    private static final String PARAM_PREFERENCE = "PREFERENCE";
    private static final String PARAM_SUCCESS_URL = "SUCCESS_URL";
    private static final String PARAM_SERVICE_NAME = "SERVICE_NAME";
    private static final String PARAM_USER_EMAIL = "USER_EMAIL";
    private static final String REQUEST_PARAM_USER_EMAIL = "userEmail";

    public ActionDoTransaction() {
        super("rbkmoney");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("rbkmoney.gate.url", "https://rbkmoney.ru/acceptpurchase.aspx"));
        this.setResultParam("commissionType", this.moduleSetup.getInt("rbkmoney.commission.type", 0));
        this.setResultParam("commissionPercent", this.moduleSetup.getDouble("rbkmoney.commission.percent", 0.0));
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"transactionDatetime:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    public void getOrderId() throws Exception {
        this.checkModuleOnContract(this.moduleId, "\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("rbkmoney.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("rbkmoney.sum.max", new BigDecimal(5000));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            String errorMessage = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!";
            this.setResultParam("errorMessage", errorMessage);
            this.execute();
            throw new BGMessageException(errorMessage);
        }
        if (this.moduleSetup.getInt("rbkmoney.commission.type", 0) == 2) {
            BigDecimal percent = this.moduleSetup.getBigDecimal("rbkmoney.commission.percent", BigDecimal.ZERO).add(new BigDecimal(100)).divide(new BigDecimal(100));
            sum = sum.multiply(percent);
        }
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        Transaction transaction = new Transaction().setSum(sum).setContractId(this.contractId).setCreateDate(new Date());
        transactionManager.update(transaction);
        Contract contract = this.getContract();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        this.setResultParam(PARAM_ESHOP_ID, this.moduleSetup.get("rbkmoney.eshop.id"));
        this.setResultParam(PARAM_ORDER_ID, new DecimalFormat("000000").format(transaction.getId()));
        this.setResultParam(PARAM_AMOUNT, new DecimalFormat("###########0.00", decimalFormatSymbols).format(sum));
        this.setResultParam(PARAM_CURRENCY, this.moduleSetup.get("rbkmoney.recipient.currency", "RUR"));
        this.setResultParam(PARAM_PREFERENCE, this.moduleSetup.get("rbkmoney.preference"));
        this.setResultParam(PARAM_SUCCESS_URL, this.moduleSetup.get("rbkmoney.success.url"));
        this.setResultParam(PARAM_FAIL_URL, this.moduleSetup.get("rbkmoney.fail.url"));
        this.setResultParam(PARAM_SERVICE_NAME, this.moduleSetup.get("rbkmoney.service.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle()));
        this.setResultParam(PARAM_USER_EMAIL, this.req.get(REQUEST_PARAM_USER_EMAIL));
        StringBuilder str = new StringBuilder();
        for (String name : new String[]{PARAM_ORDER_ID, PARAM_AMOUNT, PARAM_SERVICE_NAME, PARAM_USER_EMAIL}) {
            str.append(name).append(" = ").append(this.getResultParam(name)).append("\n");
        }
        transaction.setParameters(str.toString());
        transactionManager.update(transaction);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("TRANSACTION DATA:\n{}", (Object)str.toString());
        }
    }
}

