/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.api.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.ws.server.DynamicJaxWsHandler;
import ru.bitel.bgbilling.kernel.container.ws.server.ModuleKey;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.server.api.rest.CustomApi;
import ru.bitel.bgbilling.server.api.rest.CustomApiClass;
import ru.bitel.bgbilling.server.api.rest.CustomApiMethod;
import ru.bitel.bgbilling.server.api.webapi.WebApi;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class CustomRestApiHandler
extends DynamicJaxWsHandler {
    private static final Logger log = LogManager.getLogger();

    public CustomRestApiHandler(ServletContext context) throws BGException {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response) {
        ThreadContext parentContext = ThreadContext.get();
        ServerContext serverContext = null;
        try {
            RequestInfo requestInfo = new RequestInfo(request);
            if (requestInfo.isDefaultWebOperation) {
                boolean bl = this.invokeDefaultWebOperation(request, response);
                return bl;
            }
            serverContext = new ServerContext(Setup.getSetup(), requestInfo.moduleId, 0);
            serverContext.init();
            ThreadContext.set((ThreadContext)serverContext);
            CustomApi implementationClass = this.defineImplementationClass(requestInfo.classAnnotationValue, request, response, serverContext);
            this.invokeMethod(implementationClass, this.defineImplementationMethod(implementationClass, requestInfo), request, response);
        }
        catch (Exception ex) {
            this.logError(ex);
            try {
                response.sendError(500, ex.getMessage());
            }
            catch (IOException ex1) {
                throw new RuntimeException(ex1);
            }
        }
        finally {
            if (serverContext != null) {
                serverContext.destroy();
            }
            ThreadContext.set((ThreadContext)parentContext);
        }
        return true;
    }

    private CustomApi defineImplementationClass(String classAnnotationValue, HttpServletRequest request, HttpServletResponse response, ServerContext serverContext) throws Exception {
        CustomApi result;
        if (!Setup.getSetup().getBoolean("rest.api.enable", false)) {
            log.warn("!!!!!!!!!! REST API DISABLE (rest.api.enable=false)");
            return null;
        }
        log.debug("Define custom rest api annotation name at: " + classAnnotationValue);
        Class<?> implementation = null;
        block2: for (String classByInterface : new DynamicCodeDao(Setup.getSetup().getDBConnectionFromPool()).getActualClassesByInterface(CustomApi.class.getName())) {
            Class<?> loadedClass = DynamicClassManager.getInstance().loadClass(classByInterface);
            for (Annotation annotation : loadedClass.getAnnotations()) {
                CustomApiClass customApiClass;
                if (!(annotation instanceof CustomApiClass) || !(customApiClass = (CustomApiClass)annotation).name().equals(classAnnotationValue)) continue;
                implementation = loadedClass;
                continue block2;
            }
        }
        if (implementation == null) {
            throw new BGException("Class not found for classAnnotationValue: " + classAnnotationValue);
        }
        try {
            result = (CustomApi)implementation.getDeclaredConstructor(HttpServletRequest.class, HttpServletResponse.class, ServerContext.class, Setup.class).newInstance(new Object[]{request, response, serverContext, serverContext.getSetup()});
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private Method defineImplementationMethod(CustomApi implementationClassInstance, RequestInfo requestInfo) {
        log.debug("Define method identifier at: " + requestInfo.methodAnnotationValue);
        Method implementationMethod = null;
        for (Method m : implementationClassInstance.getClass().getDeclaredMethods()) {
            if (m.getAnnotation(CustomApiMethod.class) == null || !requestInfo.methodAnnotationValue.equals(m.getAnnotation(CustomApiMethod.class).name())) continue;
            CustomApiMethod customApiMethod = m.getAnnotation(CustomApiMethod.class);
            if (customApiMethod.method() != null && customApiMethod.method().equals(requestInfo.httpMethod)) {
                implementationMethod = m;
                continue;
            }
            if (implementationMethod != null) continue;
            implementationMethod = m;
        }
        return implementationMethod;
    }

    private boolean invokeDefaultWebOperation(HttpServletRequest request, HttpServletResponse response) {
        WebApi webApi = new WebApi(request);
        String operation = request.getParameter("operation");
        try {
            webApi.getClass().getMethod(operation, new Class[0]).invoke((Object)webApi, new Object[0]);
            Map<String, Object> dataMap = webApi.getDataMap();
            if (!dataMap.isEmpty()) {
                this.processResponse(dataMap, request, response);
            }
            return true;
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            webApi.setError(4, "M\u0435\u0442\u043e\u0434 '{1}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d".replace("{1}", operation));
            return false;
        }
    }

    private void invokeMethod(CustomApi implementationClass, Method method, HttpServletRequest request, HttpServletResponse response) throws IOException, BGException {
        try {
            String requestBody = this.getBody(request);
            Class<?>[] parametersType = method.getParameterTypes();
            if (parametersType.length == 0) {
                throw new BGException("\u0423 \u043c\u0435\u0442\u043e\u0434\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
            }
            Class<String> parameterType = parametersType[0];
            Object responseData = parameterType.isAssignableFrom(String.class) ? method.invoke((Object)implementationClass, requestBody) : (parameterType.isAssignableFrom(JSONObject.class) ? method.invoke((Object)implementationClass, new JSONObject(requestBody)) : method.invoke((Object)implementationClass, this.mapTo(requestBody, parameterType)));
            if (responseData != null) {
                this.processResponse(responseData, request, response);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BGException((Throwable)e);
        }
    }

    private String getBody(HttpServletRequest request) throws BGException {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));
        try {
            StringBuilder requestBody = new StringBuilder();
            while (reader.ready()) {
                requestBody.append(reader.readLine());
            }
            string = requestBody.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BGException((Throwable)e);
            }
        }
        reader.close();
        return string;
    }

    private <T> T mapTo(String requestBody, Class<T> type) throws BGException {
        try {
            log.debug("Try mapping requestBody to class type = " + type.getName());
            return (T)new ObjectMapper().readValue(requestBody, type);
        }
        catch (JsonProcessingException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void processResponse(Object responseData, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("UTF-8");
        this.setContentType(request, response);
        try (BufferedWriter br = new BufferedWriter(response.getWriter());){
            br.write(responseData.toString());
        }
    }

    private void setContentType(HttpServletRequest request, HttpServletResponse response) {
        String type = request.getHeader("Content-Type");
        boolean isMultipart = type != null && type.startsWith("multipart/form-data");
        response.setContentType((isMultipart ? "text/plain" : "application/json") + "; charset=UTF-8");
    }

    @Override
    protected Class<?> findEndpointClass(ModuleKey moduleKey) {
        return null;
    }

    @Override
    protected String getUrlPatternName(ModuleKey moduleKey, Class<?> implementorClass) {
        return null;
    }

    private static final class RequestInfo {
        boolean isDefaultWebOperation;
        String[] path;
        int moduleId;
        String httpMethod;
        String classAnnotationValue;
        String methodAnnotationValue;

        RequestInfo(HttpServletRequest request) throws IOException, BGException {
            this.isDefaultWebOperation = Utils.notBlankString((String)request.getParameter("operation"));
            if (!this.isDefaultWebOperation) {
                this.path = request.getPathInfo().split("/");
                if (this.path.length < 5) {
                    throw new BGException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
                }
                this.moduleId = Utils.parseInt((String)this.path[2], (int)0);
                this.httpMethod = request.getMethod();
                this.classAnnotationValue = this.path[3];
                this.methodAnnotationValue = this.path[4];
            }
        }
    }
}

