/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.xml.XmlAdapters;

public class ContractPattern
extends Id {
    private int fc;
    private int mode;
    private int status;
    private int daysToLive;
    private int patternId;
    private int domainId;
    private int paramsGroupId;
    private int namePatternId;
    private boolean hidden = false;
    private long groups;
    private BigDecimal closesumma;
    private String title;
    private String limitMode;
    private String objectString;
    private String patternMode;
    private String masterHandlerClass;
    private String masterTariffMode;
    private Set<Integer> contractLabels = null;
    private List<String> moduleList = null;
    private List<String> serviceList = null;
    private List<Integer> scriptList = new ArrayList<Integer>();
    private List<String> tariffPlanList = new ArrayList<String>();
    private List<Integer> tariffGroupList = new ArrayList<Integer>();
    private Set<Integer> masterRequiredParameterIds = new HashSet<Integer>();
    private Set<Integer> masterOptionalParameterIds = new HashSet<Integer>();
    private Document data;

    public ContractPattern copy() {
        return new ContractPattern().setId(this.id).setFc(this.fc).setMode(this.mode).setStatus(this.status).setDaysToLive(this.daysToLive).setPatternId(this.patternId).setDomainId(this.domainId).setParamsGroupId(this.paramsGroupId).setGroups(this.groups).setClosesumma(this.closesumma).setTitle(this.title).setLimitMode(this.limitMode).setNamePatternId(this.namePatternId).setHidden(this.hidden).setObjectString(this.objectString).setPatternMode(this.patternMode).setMasterHandlerClass(this.masterHandlerClass).setMasterTariffMode(this.masterTariffMode).setData(this.data).setTariffGroupList(this.tariffGroupList).setTariffPlanList(this.tariffPlanList).setMasterRequiredParameterIds(this.masterRequiredParameterIds).setMasterOptionalParameterIds(this.masterOptionalParameterIds).setScriptList(this.scriptList);
    }

    @XmlAttribute
    public BigDecimal getClosesumma() {
        return this.closesumma;
    }

    public Set<Integer> getContractLabels() throws Exception {
        if (this.contractLabels == null) {
            this.contractLabels = new HashSet<Integer>();
            if (this.getData() != null) {
                for (Element item : XMLUtils.selectElements((Node)this.getData(), (String)"//data/contractLabels/item")) {
                    int contractLabelId = Utils.parseInt((String)item.getAttribute("id"));
                    this.contractLabels.add(contractLabelId);
                }
            }
        }
        return this.contractLabels;
    }

    @XmlJavaTypeAdapter(type=Document.class, value=XmlAdapters.DocumentAdapter.class)
    public Document getData() {
        return this.data;
    }

    @XmlAttribute
    public int getDaysToLive() {
        return this.daysToLive;
    }

    @XmlAttribute
    public int getDomainId() {
        return this.domainId;
    }

    @XmlAttribute
    public int getFc() {
        return this.fc;
    }

    @XmlAttribute
    public long getGroups() {
        return this.groups;
    }

    @XmlAttribute
    public String getLimitMode() {
        return this.limitMode;
    }

    public String getMasterHandlerClass() {
        return this.masterHandlerClass;
    }

    public Set<Integer> getMasterOptionalParameterIds() {
        return this.masterOptionalParameterIds;
    }

    public Set<Integer> getMasterRequiredParameterIds() {
        return this.masterRequiredParameterIds;
    }

    public String getMasterTariffMode() {
        return this.masterTariffMode;
    }

    @XmlAttribute
    public int getMode() {
        return this.mode;
    }

    public List<String> getModuleList() {
        if (this.moduleList == null) {
            HashSet<String> moduleSet = new HashSet<String>();
            this.moduleList = new ArrayList<String>();
            if (this.data != null) {
                try {
                    for (Element moduleElement : XMLUtils.selectElements((Node)this.data, (String)"/data/modules/*")) {
                        moduleSet.add(moduleElement.getAttribute("mid"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (String val : moduleSet) {
                    this.moduleList.add(val);
                }
            }
        }
        return this.moduleList;
    }

    public int getNamePatternId() {
        return this.namePatternId;
    }

    @XmlAttribute
    public String getObjectString() {
        return this.objectString;
    }

    @XmlAttribute
    public int getParamsGroupId() {
        return this.paramsGroupId;
    }

    @XmlAttribute
    public int getPatternId() {
        return this.patternId;
    }

    public String getPatternMode() {
        return this.patternMode;
    }

    public List<Integer> getScriptList() {
        return this.scriptList;
    }

    public List<String> getServiceList() {
        if (this.serviceList == null) {
            this.serviceList = new ArrayList<String>();
            if (this.data != null) {
                try {
                    for (Element moduleElement : XMLUtils.selectElements((Node)this.data, (String)"//addServices/item")) {
                        this.serviceList.add(moduleElement.getAttribute("sid"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.serviceList;
    }

    @XmlAttribute
    public int getStatus() {
        return this.status;
    }

    public List<Integer> getTariffGroupList() {
        return this.tariffGroupList;
    }

    public List<String> getTariffPlanList() {
        return this.tariffPlanList;
    }

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    @XmlAttribute
    public int getWebMenuId() {
        int webMenuId = -1;
        if (this.data != null) {
            try {
                webMenuId = Utils.parseInt((String)this.data.getDocumentElement().getAttribute("webMenuId"), (int)-1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return webMenuId;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public ContractPattern setClosesumma(BigDecimal closesumma) {
        this.closesumma = closesumma;
        return this;
    }

    public ContractPattern setData(Document data) {
        this.data = data;
        this.moduleList = null;
        this.serviceList = null;
        return this;
    }

    public ContractPattern setDaysToLive(int daysToLive) {
        this.daysToLive = daysToLive;
        return this;
    }

    public ContractPattern setDomainId(int domainId) {
        this.domainId = domainId;
        return this;
    }

    public ContractPattern setFc(int fc) {
        this.fc = fc;
        return this;
    }

    public ContractPattern setGroups(long groups) {
        this.groups = groups;
        return this;
    }

    public ContractPattern setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public ContractPattern setId(int id) {
        super.setId(id);
        return this;
    }

    public ContractPattern setLimitMode(String limitMode) {
        this.limitMode = limitMode;
        return this;
    }

    public ContractPattern setMasterHandlerClass(String masterHandlerClass) {
        this.masterHandlerClass = masterHandlerClass;
        return this;
    }

    public ContractPattern setMasterOptionalParameterIds(Set<Integer> masterOptionalParameterIds) {
        this.masterOptionalParameterIds = masterOptionalParameterIds;
        return this;
    }

    public ContractPattern setMasterRequiredParameterIds(Set<Integer> masterRequiredParameterIds) {
        this.masterRequiredParameterIds = masterRequiredParameterIds;
        return this;
    }

    public ContractPattern setMasterTariffMode(String masterTariffMode) {
        this.masterTariffMode = masterTariffMode;
        return this;
    }

    public ContractPattern setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public ContractPattern setNamePatternId(int namePatternId) {
        this.namePatternId = namePatternId;
        return this;
    }

    public ContractPattern setObjectString(String objectString) {
        this.objectString = objectString;
        return this;
    }

    public ContractPattern setParamsGroupId(int paramsGroupId) {
        this.paramsGroupId = paramsGroupId;
        return this;
    }

    public ContractPattern setPatternId(int patternId) {
        this.patternId = patternId;
        return this;
    }

    public ContractPattern setPatternMode(String patternMode) {
        this.patternMode = patternMode;
        return this;
    }

    public ContractPattern setScriptList(List<Integer> scriptId) {
        this.scriptList = scriptId;
        return this;
    }

    public ContractPattern setStatus(int status) {
        this.status = status;
        return this;
    }

    public ContractPattern setTariffGroupList(List<Integer> value) {
        this.tariffGroupList = value;
        return this;
    }

    public ContractPattern setTariffPlanList(List<String> value) {
        this.tariffPlanList = value;
        return this;
    }

    public ContractPattern setTitle(String title) {
        this.title = title;
        return this;
    }
}

