/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdTitle;

public class ContractTariffOptionDao
extends AbstractIdDao<ContractTariffOption> {
    public ContractTariffOptionDao(Connection con) {
        super(con, "contract_tariff_option");
    }

    public List<ContractTariffOption> list(int contractId, Date date) throws SQLException {
        return this.list(contractId, date, false, true);
    }

    public List<ContractTariffOption> list(int contractId, Date date, boolean history, boolean needNonActive) throws SQLException {
        ArrayList<ContractTariffOption> result = new ArrayList<ContractTariffOption>();
        Object query = "SELECT cto.*, `to`.title FROM contract_tariff_option AS cto LEFT JOIN tariff_option AS `to` ON cto.option_id=`to`.id WHERE cto.cid=? ";
        if (date != null) {
            query = (String)query + "AND (cto.time_to IS " + (history ? "NOT NULL AND ?>cto.time_to) " : "NULL OR ?<=cto.time_to) ");
        }
        if (!needNonActive) {
            query = (String)query + "AND (cto.time_to IS NULL OR cto.time_from<cto.time_to) ";
        }
        query = (String)query + "ORDER BY time_from";
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setInt(1, contractId);
            if (date != null) {
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)date));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, true));
                }
            }
        }
        return result;
    }

    public ContractTariffOptionList getContractRealtimeTariffOptionList(int contractId, Date fromTime) throws SQLException {
        return ContractTariffOptionDao.getContractRealtimeTariffOptionList(this.con, contractId, fromTime);
    }

    public static ContractTariffOptionList getContractRealtimeTariffOptionList(Connection con, int contractId, Date fromTime) throws SQLException {
        ArrayList<ContractTariffOptionList.OptionItem> result = new ArrayList<ContractTariffOptionList.OptionItem>();
        String query = "SELECT time_from, time_to, option_id, id FROM contract_tariff_option WHERE cid=? AND (time_to IS NULL OR (?<=time_to AND time_from<time_to)) ORDER BY time_from";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)fromTime));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new ContractTariffOptionList.OptionItem(rs.getInt(3), rs.getInt(4), rs.getTimestamp(1), rs.getTimestamp(2)));
                }
            }
        }
        return new ContractTariffOptionList(result);
    }

    public Map<Integer, ContractTariffOptionList> getContractRealtimeTariffOptionListMap(Date fromTime) throws SQLException {
        HashMap<Integer, ContractTariffOptionList> result = new HashMap<Integer, ContractTariffOptionList>();
        String query = "SELECT time_from, time_to, option_id, id, cid FROM contract_tariff_option WHERE time_to IS NULL OR (?<=time_to AND time_from<time_to) ORDER BY cid, time_from";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)fromTime));
            int curContractId = 0;
            ArrayList<ContractTariffOptionList.OptionItem> optionItems = new ArrayList<ContractTariffOptionList.OptionItem>();
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int contractId = rs.getInt("cid");
                    if (curContractId != contractId) {
                        if (curContractId > 0) {
                            result.put(curContractId, new ContractTariffOptionList(optionItems));
                        }
                        optionItems = new ArrayList();
                        curContractId = contractId;
                    }
                    optionItems.add(new ContractTariffOptionList.OptionItem(rs.getInt(3), rs.getInt(4), rs.getTimestamp(1), rs.getTimestamp(2)));
                }
                if (curContractId > 0) {
                    result.put(curContractId, new ContractTariffOptionList(optionItems));
                }
            }
        }
        return result;
    }

    public ContractTariffOptionList getRoundContractRealtimeTariffOptionList(int contractId, Date fromTime) throws SQLException {
        return ContractTariffOptionDao.getRoundContractRealtimeTariffOptionList(this.con, contractId, fromTime);
    }

    public static ContractTariffOptionList getRoundContractRealtimeTariffOptionList(Connection con, int contractId, Date fromTime) throws SQLException {
        ArrayList<ContractTariffOptionList.OptionItem> result = new ArrayList<ContractTariffOptionList.OptionItem>();
        StringBuilder query = new StringBuilder().append("SELECT time_from, time_to, option_id, id FROM ").append("contract_tariff_option").append(" WHERE cid=? AND (time_to IS NULL OR (?<=time_to AND time_from<time_to)) ORDER BY time_from");
        try (PreparedStatement ps = con.prepareStatement(query.toString());){
            ps.setInt(1, contractId);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)fromTime));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Timestamp from = rs.getTimestamp(1);
                    Timestamp to = rs.getTimestamp(2);
                    long timeFrom = from != null ? from.getTime() - from.getTime() % 3600000L : 0L;
                    long timeTo = to != null ? to.getTime() - 1L : 0L;
                    result.add(new ContractTariffOptionList.OptionItem(rs.getInt(3), rs.getInt(4), timeFrom, timeTo));
                }
            }
        }
        return new ContractTariffOptionList(result);
    }

    private ContractTariffOption getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        int userId = rs.getInt("uid");
        return new ContractTariffOption().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setTimeFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("time_from"))).setTimeTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("time_to"))).setOptionId(rs.getInt("option_id")).setOptionComment(rs.getString("option_comment")).setActivatedMode(rs.getInt("activated_mode")).setActivatedTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("activated_time"))).setDeactivatedTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("deactivated_time"))).setChargeId(rs.getInt("charge_id")).setSum(rs.getBigDecimal("summa")).setUserId(userId).setUserTitle(Optional.ofNullable(UserMap.getUser(userId)).map(IdTitle::getTitle).orElse("")).setOptionTitle(titleLoad ? rs.getString("to.title") : "");
    }

    protected ContractTariffOption getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    public void update(ContractTariffOption contractTariffOption) throws SQLException {
        super.update((Object)contractTariffOption);
    }

    public void update(ContractTariffOption contractTariffOption, boolean checkDeactivated) throws SQLException {
        this.updateImpl(contractTariffOption, checkDeactivated);
    }

    protected void updateImpl(ContractTariffOption contractOption) throws SQLException {
        this.updateImpl(contractOption, true);
    }

    protected void updateImpl(ContractTariffOption contractOption, boolean checkDeactivated) throws SQLException {
        boolean timeToNotNull;
        boolean update = contractOption.getId() > 0;
        boolean bl = timeToNotNull = contractOption.getTimeTo() != null;
        String where = timeToNotNull ? (checkDeactivated ? " AND time_to IS NULL" : "") : " AND (time_to IS NOT NULL AND deactivated_time IS NOT NULL)";
        String query = (update ? "UPDATE " : "INSERT INTO ") + "contract_tariff_option" + (String)(update ? " SET time_to=?, deactivated_time=?, uid=?, option_comment=? WHERE id=?" + where : " SET cid=?, time_from=?, time_to=?, option_id=?, activated_mode=?, activated_time=?, deactivated_time=?, charge_id=?, summa=?, uid=?, option_comment=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            if (update) {
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractOption.getTimeTo()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)(timeToNotNull ? contractOption.getTimeTo() : contractOption.getDeactivatedTime())));
                ps.setInt(index++, contractOption.getUserId());
                ps.setString(index++, contractOption.getOptionComment());
                ps.setInt(index++, contractOption.getId());
                if (ps.executeUpdate() == 0) {
                    throw new BGRuntimeException(timeToNotNull ? "\u041e\u043f\u0446\u0438\u044f \u0443\u0436\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430!" : "\u042d\u0442\u0443 \u043e\u043f\u0446\u0438\u044e \u043d\u0435\u043b\u044c\u0437\u044f \u0440\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c!");
                }
            } else {
                ps.setInt(index++, contractOption.getContractId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractOption.getTimeFrom()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractOption.getTimeTo()));
                ps.setInt(index++, contractOption.getOptionId());
                ps.setInt(index++, contractOption.getActivatedMode());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractOption.getActivatedTime()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)contractOption.getDeactivatedTime()));
                ps.setInt(index++, contractOption.getChargeId());
                ps.setBigDecimal(index++, contractOption.getSum());
                ps.setInt(index++, contractOption.getUserId());
                ps.setString(index++, contractOption.getOptionComment());
                ps.executeUpdate();
                contractOption.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }
}

