/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class OrganizationDao
extends AbstractDao<Organization> {
    public OrganizationDao(Connection con, int moduleId) {
        super(con, "bill_organization", moduleId);
    }

    public Organization getOrganization(int id) throws SQLException {
        return (Organization)this.get("id=?", new Object[]{id});
    }

    public List<Organization> getOrganizationList() throws SQLException {
        return this.list("", "title", new Object[0]);
    }

    public void deleteOrganization(int organizationId) throws SQLException {
        this.delete("id=? AND NOT `default_org`", new Object[]{organizationId});
    }

    public void setDefaultOrganization(int organizationId) throws SQLException {
        String query = "UPDATE bill_organization_" + this.moduleId + " SET default_org=(id=?), in_use=if (id=?, true, in_use)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, organizationId);
            ps.setInt(2, organizationId);
            ps.executeUpdate();
        }
    }

    public Organization getDefaultOrganization() throws SQLException {
        Organization result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE default_org=true";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result = this.getFromRS(rs);
            }
        }
        return result;
    }

    public List<IdTitle> getOrganizationTitleList(Boolean inUse) throws SQLException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        String query = "SELECT id, title FROM " + this.tableName + (String)(inUse == null ? "" : " WHERE in_use=" + inUse.toString()) + " ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
        }
        return result;
    }

    protected Organization getFromRS(ResultSet rs) throws SQLException {
        String data = rs.getString("data");
        return new Organization().setId(rs.getInt("id")).setTitle(rs.getString("title")).setDefaultOrganization(rs.getBoolean("default_org")).setInUse(rs.getBoolean("in_use")).setComment(rs.getString("comment")).setData(Utils.isEmptyString((String)data) ? "{}" : data);
    }

    protected void updateImpl(Organization organization) throws SQLException {
        boolean update = organization.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, comment=?, data=?, default_org=?, in_use=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, organization.getTitle());
            ps.setString(index++, organization.getComment());
            ps.setString(index++, Utils.isEmptyString((String)organization.getData()) ? "{}" : organization.getData());
            ps.setBoolean(index++, organization.isDefaultOrganization());
            ps.setBoolean(index++, organization.isInUse());
            if (update) {
                ps.setInt(index++, organization.getId());
            }
            ps.executeUpdate();
            if (!update) {
                organization.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

