/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGNavButton;
import ru.bitel.bgbilling.client.common.BGNextPeriodButton;
import ru.bitel.bgbilling.client.common.BGPeriodModeButton;
import ru.bitel.bgbilling.client.common.BGPrevPeriodButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ModelPeriod;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class BGControlPanelPeriodNavigation
extends JPanel {
    ModelPeriod model = new ModelPeriod();
    protected BGCalendarButton dateTextField1 = new BGCalendarButton();
    protected BGCalendarButton dateTextField2 = new BGCalendarButton();
    protected BGPeriodModeButton periodButton = new BGPeriodModeButton(this.model);
    protected BGNavButton prevPeriodButton = new BGPrevPeriodButton(this.model);
    protected BGNavButton nextPeriodButton = new BGNextPeriodButton(this.model);

    public BGControlPanelPeriodNavigation() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.prevPeriodButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.dateTextField1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.periodButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.dateTextField2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.nextPeriodButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.dateTextField1.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("updateCalendar")) {
                this.firePropertyChange("date1", evt.getOldValue(), evt.getNewValue());
                this.nextPeriodButton.setDateFrom(this.dateTextField1.getCalendar());
                this.prevPeriodButton.setDateFrom(this.dateTextField1.getCalendar());
                this.setPeriodButton();
                this.model.resetDetectMode(this.dateTextField1.getCalendar(), this.dateTextField2.getCalendar());
                this.checkDateAndSetEnabled();
            }
        });
        this.dateTextField2.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("updateCalendar")) {
                this.firePropertyChange("date2", evt.getOldValue(), evt.getNewValue());
                this.nextPeriodButton.setDateTo(this.dateTextField2.getCalendar());
                this.prevPeriodButton.setDateTo(this.dateTextField2.getCalendar());
                this.model.resetDetectMode(this.dateTextField1.getCalendar(), this.dateTextField2.getCalendar());
                this.setPeriodButton();
                this.checkDateAndSetEnabled();
            }
        });
        this.periodButton.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("setCalendar")) {
                this.dateTextField1.setLocalDate(this.periodButton.getDateFrom());
                this.dateTextField2.setLocalDate(this.periodButton.getDateTo());
                this.firePropertyChange("period", evt.getOldValue(), evt.getNewValue());
                this.setPeriodButton();
            }
        });
        this.nextPeriodButton.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("nextPeriod")) {
                this.dateTextField1.setLocalDate(this.nextPeriodButton.getDateFrom());
                this.dateTextField2.setLocalDate(this.nextPeriodButton.getDateTo());
                this.firePropertyChange("period", evt.getOldValue(), evt.getNewValue());
                this.setPeriodButton();
            }
        });
        this.prevPeriodButton.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("prevPeriod")) {
                this.dateTextField1.setLocalDate(this.prevPeriodButton.getDateFrom());
                this.dateTextField2.setLocalDate(this.prevPeriodButton.getDateTo());
                this.firePropertyChange("period", evt.getOldValue(), evt.getNewValue());
                this.setPeriodButton();
            }
        });
    }

    private void checkDateAndSetEnabled() {
        if (this.dateTextField1.getCalendar() != null && this.dateTextField2.getCalendar() != null) {
            this.prevPeriodButton.setEnabled(true);
            this.nextPeriodButton.setEnabled(true);
        } else {
            this.prevPeriodButton.setEnabled(false);
            this.nextPeriodButton.setEnabled(false);
        }
    }

    private void setPeriodButton() {
        this.nextPeriodButton.setDateFrom(this.dateTextField1.getCalendar());
        this.prevPeriodButton.setDateFrom(this.dateTextField1.getCalendar());
        this.nextPeriodButton.setDateTo(this.dateTextField2.getCalendar());
        this.prevPeriodButton.setDateTo(this.dateTextField2.getCalendar());
        this.checkDateAndSetEnabled();
    }

    public void setDateFrom(LocalDate date) {
        this.dateTextField1.setLocalDate(date);
        this.checkDateAndSetEnabled();
    }

    public void undoDateCalendar1() {
        this.dateTextField1.undoCalendar();
    }

    public Period getPeriod() {
        return new Period(this.getDateFrom(), this.getDateTo());
    }

    public void setPeriod(Period period) {
        if (period != null) {
            this.setDateFrom(period.getLocalDateFrom());
            this.setDateTo(period.getLocalDateTo());
        } else {
            this.setDateFrom(null);
            this.setDateTo(null);
        }
    }

    public void setDateTo(LocalDate date) {
        this.dateTextField2.setLocalDate(date);
        this.checkDateAndSetEnabled();
    }

    public void undoDateCalendar2() {
        this.dateTextField2.undoCalendar();
    }

    public void setDateString1(String dateString1) {
        this.dateTextField1.setText(dateString1);
    }

    public String getDateString1() {
        return this.dateTextField1.getText().trim();
    }

    public void setDateString2(String dateString2) {
        this.dateTextField2.setText(dateString2);
    }

    public String getDateString2() {
        return this.dateTextField2.getText().trim();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    public void reset() {
        this.dateTextField1.setLocalDate(null);
        this.dateTextField2.setLocalDate(null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.dateTextField1.setEnabled(enabled);
        this.dateTextField2.setEnabled(enabled);
        this.periodButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public Date getDateFrom() {
        return TimeUtils.convertCalendarToDate(this.dateTextField1.getCalendar());
    }

    public Date getDateTo() {
        return TimeUtils.convertCalendarToDate(this.dateTextField2.getCalendar());
    }

    public void setTitleBorderName(String title) {
        Border b = this.getBorder();
        if (b instanceof CompoundBorder) {
            b = ((CompoundBorder)b).getOutsideBorder();
        }
        if (b instanceof TitledBorder) {
            ((TitledBorder)b).setTitle(title);
        } else if (b == null) {
            this.setBorder(BorderFactory.createCompoundBorder(new BGTitleBorder(title), new EmptyBorder(0, 5, 5, 5)));
        }
    }
}

