/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.service.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Node;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityDao;
import ru.bitel.oss.systems.inventory.service.common.bean.ServiceSpec;

public class ServiceSpecDao
extends AbstractEntityDao<ServiceSpec>
implements Directory<ServiceSpec> {
    public ServiceSpecDao(Connection con) {
        this(con, 0, 0);
    }

    public ServiceSpecDao(Connection con, int moduleId) {
        this(con, moduleId, 0);
    }

    public ServiceSpecDao(Connection con, int moduleId, int userId) {
        super(con, moduleId, userId, "inv_service_spec", null);
    }

    protected void updateImpl(ServiceSpec b) throws BGException, SQLException {
        if (b.getId() <= 0) {
            PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (entityId, parentId, title, moduleId, identifier, dateFrom, dateTo, comment, description) VALUES (?,?,?,?,?,?,?,?,?)", 1);
            ps.setInt(1, b.getEntityId());
            ps.setInt(2, b.getParentId());
            ps.setString(3, b.getTitle());
            ps.setInt(4, b.getModuleId());
            ps.setString(5, b.getIdentifier());
            ps.setDate(6, TimeUtils.convertDateToSqlDate((java.util.Date)b.getDateFrom()));
            ps.setDate(7, TimeUtils.convertDateToSqlDate((java.util.Date)b.getDateTo()));
            ps.setString(8, b.getComment());
            ps.setString(9, b.getDescription());
            ps.executeUpdate();
            b.setId(ServerUtils.lastInsertId(ps));
        } else {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET entityId=?, title=?, moduleId=?, identifier=?, dateFrom=?, dateTo=?, comment=?, description=? WHERE id=?");
            ps.setInt(1, b.getEntityId());
            ps.setString(2, b.getTitle());
            ps.setInt(3, b.getModuleId());
            ps.setString(4, b.getIdentifier());
            ps.setDate(5, TimeUtils.convertDateToSqlDate((java.util.Date)b.getDateFrom()));
            ps.setDate(6, TimeUtils.convertDateToSqlDate((java.util.Date)b.getDateTo()));
            ps.setString(7, b.getComment());
            ps.setString(8, b.getDescription());
            ps.setInt(9, b.getId());
            ps.executeUpdate();
        }
    }

    public List<ServiceSpec> list(int moduleId, java.util.Date dateFrom, java.util.Date dateTo, String title, List<FilterEntityAttr> entityFilter) throws BGException {
        Date sqlDateFrom = TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom);
        Date sqlDateTo = TimeUtils.convertDateToSqlDate((java.util.Date)dateTo);
        return super.list(true, null, null, null, entityFilter, "(? OR moduleId=?) AND (? OR dateFrom IS NULL OR dateFrom<=?) AND (? OR dateTo IS NULL OR ?<=dateTo) AND (? OR " + this.tableName + ".title LIKE ?)", this.tableName + ".id", null, moduleId < 0, moduleId, sqlDateTo == null, sqlDateTo, sqlDateFrom == null, sqlDateFrom, Utils.isBlankString((String)title), "%" + title + "%");
    }

    @Override
    public List<ServiceSpec> list() throws BGException {
        return this.list(-1, null, null, null, null);
    }

    @Override
    protected ServiceSpec getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        ServiceSpec result = new ServiceSpec();
        result.setId(rs.getInt("id"));
        result.setEntityId(rs.getInt("entityId"));
        result.setTitle(rs.getString("title"));
        result.setParentId(rs.getInt("parentId"));
        result.setModuleId(rs.getInt("moduleId"));
        result.setIdentifier(rs.getString("identifier"));
        result.setDateFrom((java.util.Date)rs.getDate("dateFrom"));
        result.setDateTo((java.util.Date)rs.getDate("dateTo"));
        result.setComment(rs.getString("comment"));
        result.setDescription(rs.getString("description"));
        return result;
    }

    @Override
    public ServiceSpec get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    public void move(int newParentId, Set<Integer> children) throws BGException {
        if (newParentId < 0 || children == null || children.size() == 0) {
            throw new BGIllegalArgumentException();
        }
        List<ServiceSpec> list = this.list();
        for (Integer id : children) {
            ServiceSpec child = (ServiceSpec)TreeUtils.tree(list, (int)id);
            if (TreeUtils.find((Node)child, (int)newParentId) == null) continue;
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0439.");
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=? WHERE id IN (" + Utils.toString(children) + ")");
            ps.setInt(1, newParentId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

