/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dns;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Update;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.WorkerThreadFactory;

public class DnsClient
implements Runnable,
AutoCloseable {
    private static final Logger logger = LogManager.getLogger();
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(4, (ThreadFactory)new WorkerThreadFactory("dns-sender", null, null));
    volatile ScheduledFuture<?> scheduledFuture;
    private boolean updateDNS = false;
    private BlockingQueue<Task> queue = new ArrayBlockingQueue<Task>(100);
    private Name zone;
    private String dnsResolver;
    private String sharedKeyName;
    private String sharedKeyValue;
    private int ttl;

    public DnsClient(ParameterMap setup) {
        this(setup.get("dns.zone", null), setup.get("dns.resolver", null), setup.get("dns.sharedKey.name", null), setup.get("dns.sharedKey.value", null), setup.getInt("dns.ttl", 3600));
    }

    public DnsClient(String zone, String dnsResolver, String sharedKeyName, String sharedKeyValue, int ttl) {
        this.dnsResolver = dnsResolver;
        this.sharedKeyName = sharedKeyName;
        this.sharedKeyValue = sharedKeyValue;
        this.ttl = ttl;
        boolean bl = this.updateDNS = Utils.notBlankString((String)zone) && Utils.notBlankString((String)this.dnsResolver) && Utils.notBlankString((String)this.sharedKeyName) && Utils.notBlankString((String)this.sharedKeyValue);
        if (this.updateDNS) {
            try {
                this.zone = Name.fromString((String)zone);
            }
            catch (TextParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.zone = null;
                this.updateDNS = false;
            }
        }
        logger.info("DnsClient init => " + this.updateDNS);
        if (this.updateDNS) {
            logger.info("zone: " + zone + "; resolver: " + dnsResolver + "; sharedKeyName: " + sharedKeyName + "; sharedKeyValue: " + sharedKeyValue);
        }
    }

    public void registerAsync(String hostname, String record) {
        if (!this.updateDNS) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Async register host " + hostname + " => " + record);
        }
        this.addTask(new Task(true, hostname, record));
    }

    public void unregisterAsync(String hostname) {
        if (!this.updateDNS) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Async unregister host " + hostname);
        }
        this.addTask(new Task(false, hostname, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(Task task) {
        if (this.queue.offer(task)) {
            return;
        }
        DnsClient dnsClient = this;
        synchronized (dnsClient) {
            if (!this.queue.offer(task)) {
                ArrayList<Task> list = new ArrayList<Task>();
                this.queue.drainTo(list);
                list.add(task);
                this.task(list);
            }
            if (this.scheduledFuture == null) {
                this.scheduledFuture = EXECUTOR_SERVICE.scheduleWithFixedDelay(new WeakWorker(this), 0L, 500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Task> list = new ArrayList<Task>();
        this.queue.drainTo(list);
        if (list.size() > 0) {
            this.task(list);
        }
        DnsClient dnsClient = this;
        synchronized (dnsClient) {
            if (this.queue.size() == 0 && this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
                this.scheduledFuture = null;
            }
        }
    }

    private synchronized void task(List<Task> list) {
        try {
            int i;
            Update update = new Update(this.zone);
            int size = list.size();
            for (i = 0; i < size; ++i) {
                Task task = list.get(i);
                Name host = Name.fromString((String)task.hostname, (Name)this.zone);
                if (task.register) {
                    update.replace(host, 1, (long)this.ttl, task.record);
                    if (logger.isInfoEnabled()) {
                        logger.info("Register host " + String.valueOf(host) + " => " + task.record);
                    }
                } else {
                    update.delete(host);
                    if (logger.isInfoEnabled()) {
                        logger.info("Unregister host " + String.valueOf(host));
                    }
                }
                if ((i + 1) % 5 != 0) continue;
                SimpleResolver res = new SimpleResolver(this.dnsResolver);
                res.setTSIGKey(new TSIG(TSIG.HMAC_MD5, this.sharedKeyName, this.sharedKeyValue));
                res.setTCP(false);
                res.send((Message)update);
                update = new Update(this.zone);
            }
            if ((i + 1) % 5 != 0) {
                SimpleResolver res = new SimpleResolver(this.dnsResolver);
                res.setTSIGKey(new TSIG(TSIG.HMAC_MD5, this.sharedKeyName, this.sharedKeyValue));
                res.setTCP(false);
                res.send((Message)update);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean register(String hostname, String record) {
        if (!this.updateDNS) {
            return false;
        }
        try {
            Name host = Name.fromString((String)hostname, (Name)this.zone);
            if (logger.isInfoEnabled()) {
                logger.info("Register host " + String.valueOf(host) + " => " + record);
            }
            Update update = new Update(this.zone);
            update.replace(host, 1, (long)this.ttl, record);
            SimpleResolver res = new SimpleResolver(this.dnsResolver);
            res.setTSIGKey(new TSIG(TSIG.HMAC_MD5, this.sharedKeyName, this.sharedKeyValue));
            res.setTCP(false);
            res.send((Message)update);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean unregister(String hostname) {
        if (!this.updateDNS) {
            return false;
        }
        try {
            Name host = Name.fromString((String)hostname, (Name)this.zone);
            if (logger.isInfoEnabled()) {
                logger.info("Unregister host " + String.valueOf(host));
            }
            Update update = new Update(this.zone);
            update.delete(host);
            SimpleResolver res = new SimpleResolver(this.dnsResolver);
            res.setTSIGKey(new TSIG(TSIG.HMAC_MD5, this.sharedKeyName, this.sharedKeyValue));
            res.setTCP(false);
            res.send((Message)update);
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.run();
        DnsClient dnsClient = this;
        synchronized (dnsClient) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
        }
    }

    static final class Task {
        final boolean register;
        final String hostname;
        final String record;

        public Task(boolean register, String hostname, String record) {
            this.register = register;
            this.hostname = hostname;
            this.record = record;
        }
    }

    static final class WeakWorker
    implements Runnable {
        private final WeakReference<DnsClient> ref;

        WeakWorker(DnsClient dnsClient) {
            this.ref = new WeakReference<DnsClient>(dnsClient);
        }

        @Override
        public void run() {
            DnsClient dnsClient = (DnsClient)this.ref.get();
            if (dnsClient != null) {
                dnsClient.run();
            }
        }
    }
}

