/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.common.service;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.util.List;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.shop.common.bean.ContractStockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeValue;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemType;
import ru.bitel.bgbilling.plugins.shop.common.bean.Warehouse;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService
@XmlSeeAlso(value={ContractStockItem.class, StockItem.class})
public interface WarehouseService {
    @WebMethod
    public List<Warehouse> getWarehouseList() throws Exception, BGMessageException;

    @WebMethod
    public Warehouse getWarehouse(@WebParam(name="id") int var1) throws Exception, BGMessageException;

    @WebMethod
    public Warehouse updateWarehouse(@WebParam(name="warehouse") Warehouse var1) throws Exception, BGMessageException;

    @WebMethod
    public void deleteWarehouse(@WebParam(name="warehouseId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public StockItem getStockItemById(@WebParam(name="stockItemId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public StockItem updateStockItem(@WebParam(name="stockItem") StockItem var1) throws Exception, BGMessageException;

    @WebMethod
    public SearchResult<StockItem> getWarehouseItemsByType(@WebParam(name="warehouseId") int var1, @WebParam(name="stockItemTypeId") int var2, @WebParam(name="page") Page var3) throws Exception, BGMessageException;

    @WebMethod
    public void deleteStockItem(@WebParam(name="stockItemId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public StockItemType getStockItemType(@WebParam(name="stockItemTypeId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public StockItemType getStockItemTypeTreeRoot() throws Exception, BGMessageException;

    @WebMethod
    public List<StockItemType> stockItemTypeList() throws Exception, BGMessageException;

    @WebMethod
    public StockItemType updateStockItemType(@WebParam(name="stockItemType") StockItemType var1) throws Exception, BGMessageException;

    @WebMethod
    public void deleteStockItemType(@WebParam(name="stockItemTypeId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public List<StockItemType> getStockItemTypesByWarehouse(@WebParam(name="warehouseId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public List<StockItemAttributeKit> getAttributeKitList() throws Exception, BGMessageException;

    @WebMethod
    public StockItemAttributeKit getAttributeKit(@WebParam(name="attributeKitId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public StockItemAttributeKit updateAttributeKit(@WebParam(name="attributeKit") StockItemAttributeKit var1) throws Exception, BGMessageException;

    @WebMethod
    public void deleteAttributeKit(@WebParam(name="attributeKitId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public StockItemAttribute updateAttribute(@WebParam(name="attribute") StockItemAttribute var1) throws Exception, BGMessageException;

    @WebMethod
    public List<StockItemAttribute> getAttributeList() throws Exception, BGMessageException;

    @WebMethod
    public void deleteAttribute(@WebParam(name="attributeId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public List<StockItemAttributeValue> getAttributeValuesByStockItem(@WebParam(name="stockItemId") int var1) throws Exception, BGMessageException;

    @WebMethod
    public int getCurrentUserId() throws Exception, BGMessageException;

    @WebMethod
    public List<StockItem> searchStockItems(@WebParam(name="warehouseId") int var1, @WebParam(name="attributeId") int var2, @WebParam(name="data") String var3) throws Exception, BGMessageException;
}

