/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.task;

import bitel.billing.server.contract.ContractRemover;
import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.mail.MailTaskContractCleaner;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractRemoveRule;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractRemoveRuleService;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ContractCleaner
extends TaskBase {
    private int _max_by_close = 10;
    private int _max_by_balance = 10;
    private String _email;
    private String _folder = "/";

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0440\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432.";
    }

    @Override
    protected boolean initTask() {
        this._max_by_close = this.taskSetup.getInt("max_closed", this._max_by_close);
        this._max_by_balance = this.taskSetup.getInt("max_balance", this._max_by_balance);
        this._email = this.taskSetup.get("email", this._email);
        this._folder = this.taskSetup.get("folder", this._folder);
        return true;
    }

    @Override
    public void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection slaveCon = this.setup.getDBSlaveConnectionFromPool();
             ContractRemover remover = new ContractRemover(con, this._folder);){
            ServerContext context = (ServerContext)ServerContext.get();
            ContractRemoveRuleService removeRuleService = context.getService(ContractRemoveRuleService.class, 0);
            List<Integer> cidsForRemoveByClose = new ArrayList<Integer>();
            List<Integer> cidsForRemoveByBalance = new ArrayList();
            List<ContractRemoveRule> removeRules = removeRuleService.getContractRemoveRules();
            removeRules.removeIf(r -> r.getDateFrom() == null || r.getDateFrom().isAfter(LocalDate.now()) || r.getDateTo() != null && r.getDateFrom().isBefore(LocalDate.now()));
            for (ContractRemoveRule removeRule : removeRules) {
                if (ContractRemoveRule.RemoveRuleType.BALANCE.equals((Object)removeRule.getRemoveRuleType())) {
                    cidsForRemoveByBalance.addAll(this.getCidsByRuleBalanceType(slaveCon, removeRule));
                    continue;
                }
                if (!ContractRemoveRule.RemoveRuleType.TIME.equals((Object)removeRule.getRemoveRuleType())) continue;
                cidsForRemoveByClose.addAll(this.getCidsByRuleTimeType(slaveCon, removeRule));
            }
            cidsForRemoveByBalance = cidsForRemoveByBalance.stream().limit(this._max_by_balance).toList();
            cidsForRemoveByClose = cidsForRemoveByClose.stream().limit(this._max_by_close).toList();
            ArrayList<Integer> contractIdsForRemove = new ArrayList<Integer>();
            contractIdsForRemove.addAll(cidsForRemoveByBalance);
            contractIdsForRemove.addAll(cidsForRemoveByClose);
            if (Utils.isEmptyCollection(contractIdsForRemove)) {
                this.getLogger().info("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            ContractUtils cu = new ContractUtils(con);
            StringBuilder msg = new StringBuilder();
            for (Integer cid : contractIdsForRemove) {
                msg.append("\n");
                msg.append(cu.getContractTitle(cid.intValue(), true));
            }
            if (this._email != null && !msg.isEmpty()) {
                new MailMsg((Preferences)this.setup).sendMessage(new MailTaskContractCleaner().setRecipients(this._email).setSubject("These contracts were deleted!").addTextPart("text", msg.toString()));
            }
            this.getLogger().info("Removing {}", contractIdsForRemove);
            String errors = remover.removeContracts(contractIdsForRemove, true);
            if (Utils.notBlankString(errors)) {
                this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0438 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:\n{}", (Object)errors);
            }
        }
        catch (Exception e1) {
            this.logError(e1);
            this.error = e1;
        }
    }

    private List<Integer> getCidsByRuleTimeType(Connection connection, ContractRemoveRule removeRule) throws SQLException {
        ArrayList<Integer> cids = new ArrayList<Integer>();
        Object query = "SELECT c.id FROM contract AS c LEFT JOIN contract_label_link AS cll ON c.id=cll.contract_id WHERE c.date2 IS NOT NULL AND c.date2 < date_sub(curdate(), interval ? month) AND c.scid=0";
        if (Utils.notEmptyCollection(removeRule.getStatuses())) {
            query = (String)query + " AND status IN ( " + Utils.toString(removeRule.getStatuses()) + ")";
        }
        if (Utils.notEmptyCollection(removeRule.getLabels())) {
            query = (String)query + " AND cll.label_id IN (" + Utils.toString(removeRule.getLabels()) + ")";
        }
        query = (String)query + " ORDER BY title";
        try (PreparedStatement ps = connection.prepareStatement((String)query);){
            ps.setInt(1, removeRule.getTimeCount());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    cids.add(rs.getInt(1));
                }
            }
        }
        return cids;
    }

    private List<Integer> getCidsByRuleBalanceType(Connection connection, ContractRemoveRule removeRule) throws SQLException {
        ArrayList<Integer> cids = new ArrayList<Integer>();
        float money = removeRule.getBalance().floatValue();
        String periodSql = ContractRemoveRule.TypeRuleRemoveByTime.DAY.equals((Object)removeRule.getTypeRuleRemoveByTime()) ? "DAY" : "MONTH";
        String query = "SELECT c.id FROM contract AS c LEFT JOIN contract_label_link AS cll ON c.id=cll.contract_id WHERE (( c.date1 IS NULL ) OR DATE_ADD( c.date1, INTERVAL ? " + periodSql + " )<=NOW()) AND c.scid=0";
        if (Utils.notEmptyCollection(removeRule.getStatuses())) {
            query = query + " AND status IN ( " + Utils.toString(removeRule.getStatuses()) + ")";
        }
        if (Utils.notEmptyCollection(removeRule.getLabels())) {
            query = query + " AND cll.label_id IN (" + Utils.toString(removeRule.getLabels()) + ")";
        }
        int months = removeRule.getTimeCount();
        if (ContractRemoveRule.TypeRuleRemoveByTime.DAY.equals((Object)removeRule.getTypeRuleRemoveByTime())) {
            Calendar from = (Calendar)this.getOperatingTime().clone();
            from.add(6, -removeRule.getTimeCount());
            Calendar to = (Calendar)this.getOperatingTime().clone();
            months = to.get(2) + 12 * to.get(1) - (from.get(2) + 12 * from.get(1));
        }
        int count = 0;
        try (BalanceUtils bu = new BalanceUtils(connection);
             PreparedStatement ps = connection.prepareStatement(query);){
            ps.setInt(1, removeRule.getTimeCount());
            try (ResultSet rsCidFromGroups = ps.executeQuery();){
                while (rsCidFromGroups.next()) {
                    int cid = rsCidFromGroups.getInt(1);
                    if (!(bu.getBalance(this.getOperatingTime().getTime(), cid).floatValue() <= money)) continue;
                    boolean delete = true;
                    int i = 0;
                    do {
                        Calendar time = (Calendar)this.getOperatingTime().clone();
                        time.add(2, -i);
                        if (!bu.wasMoveByAccount(time, cid)) continue;
                        delete = false;
                        break;
                    } while (++i < months);
                    if (!delete) continue;
                    cids.add(cid);
                    if (++count <= this._max_by_balance) continue;
                    break;
                }
            }
        }
        return cids;
    }
}

