/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.script;

import bitel.billing.module.common.BSHEditor;
import bitel.billing.module.common.CheckListener;
import bitel.billing.module.script.BackupHistoryBGPanel;
import bitel.billing.module.script.ScriptFunctions;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPluginControls;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.script.common.bean.Revision;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class FunctionEditor
extends BGPanel {
    private CardLayout cardLayout = new CardLayout();
    private BackupHistoryBGPanel bhPanel;
    private ScriptFunctions scriptFunctions;
    private JTextField title_TF = new JTextField();
    private BSHEditor code_TA = new BSHEditor();
    private BGControlPanelListSelect eventTypes = new BGControlPanelListSelect();
    private Revision currentRevision = new Revision();
    private JButton saveButton = new JButton();
    private BGControlPanelPluginControls bgPluginnedPanel;

    public FunctionEditor(ScriptFunctions scriptFunctions) {
        this.scriptFunctions = scriptFunctions;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.code_TA.getTextPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 83) {
                    FunctionEditor.this.save();
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(this.cardLayout);
        JPanel paramPanel = new JPanel(new GridBagLayout());
        paramPanel.setBorder(new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b "));
        paramPanel.setMinimumSize(new Dimension(300, 400));
        paramPanel.setPreferredSize(new Dimension(300, 400));
        JPanel codePanel = new JPanel(new GridBagLayout());
        codePanel.setBorder(new BGTitleBorder(" \u041a\u043e\u0434 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 "));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        this.eventTypes.setBorder(new BGTitleBorder(" \u0421\u043e\u0431\u044b\u0442\u0438\u044f "));
        this.title_TF.setMinimumSize(new Dimension(150, 24));
        this.title_TF.setPreferredSize(new Dimension(200, 24));
        JButton closeButton = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        closeButton.setToolTipText("");
        closeButton.addActionListener(e -> this.cancelPressed());
        this.saveButton.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c (READ-ONLY)");
        this.saveButton.addActionListener(e -> this.save());
        this.buttonChange(false);
        JButton historyButton = new JButton("\u0418\u0441\u0442\u043e\u0440\u0438\u044f");
        historyButton.addActionListener(e -> {
            int scriptId = this.id;
            if (scriptId > 0) {
                this.bhPanel.currentId = scriptId;
                this.bhPanel.trySetData();
                this.cardLayout.show(this, "history");
            }
        });
        JButton backupButton = new JButton();
        backupButton.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e");
        backupButton.addActionListener(e -> ClientUtils.showMessageDialog("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434"));
        paramPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        paramPanel.add((Component)this.title_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        paramPanel.add((Component)this.eventTypes, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        codePanel.add((Component)this.code_TA, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        controlPanel.add((Component)backupButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        controlPanel.add((Component)historyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        controlPanel.add((Component)this.saveButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        controlPanel.add((Component)closeButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.bgPluginnedPanel = new BGControlPanelPluginControls(FunctionEditor.class.getName(), this, new Object[0]);
        this.bgPluginnedPanel.invokeInitBGPanel(null, -1);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)paramPanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)codePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.bgPluginnedPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 0, 2), 0, 0));
        mainPanel.add((Component)controlPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        DocumentListener dlistener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FunctionEditor.this.buttonChange(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FunctionEditor.this.buttonChange(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FunctionEditor.this.buttonChange(true);
            }
        };
        this.code_TA.getTextPane().getDocument().addDocumentListener(dlistener);
        this.title_TF.getDocument().addDocumentListener(dlistener);
        new CheckListener(this.eventTypes.getList()){

            @Override
            public void keyPressed(KeyEvent e) {
                FunctionEditor.this.buttonChange(true);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FunctionEditor.this.buttonChange(true);
            }
        };
        this.add((Component)mainPanel, "main");
        this.bhPanel = new BackupHistoryBGPanel(1, this.cardLayout, this);
        this.add((Component)this.bhPanel, "history");
        this.cardLayout.show(this, "main");
    }

    @Override
    public void setData() throws Exception {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        if (this.id == 0) {
            this.title_TF.setText("");
            String defaultCode = "import bitel.billing.server.util.*;\n\npublic void onEvent( event, setup, con, conSlave )\n{\n\tprint( \"Hello, world!\" );\n}";
            this.code_TA.setText(defaultCode);
            this.eventTypes.setListValues(null);
            ClientUtils.showMessageDialog("\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434");
        } else {
            Request request = new Request().setModule(this.module).setAction("GetFunction").setAttribute("id", this.id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.eventTypes.setListValues(XMLUtils.selectText(doc, "//function/@event_types"));
                this.title_TF.setText(XMLUtils.selectText(doc, "//function/@title"));
                this.code_TA.setText(ClientUtils.linesToString(XMLUtils.selectElement(doc, "//code")));
                this.currentRevision.setId(this.id);
                this.currentRevision.setUserId(Utils.parseInt(XMLUtils.selectText(doc, "//function/@userId")));
                this.currentRevision.setTimeRevision(TimeUtils.convertStringToDate(XMLUtils.selectText(doc, "//function/@timeRevision"), "yyyy-MM-dd HH:mm:ss"));
            }
        }
        this.buttonChange(false);
        this.bgPluginnedPanel.invokeSetData(new Object[0]);
    }

    private void buttonChange(boolean enable) {
        this.saveButton.setEnabled(false);
    }

    private void init() {
        Request request = new Request().setModule(this.module).setAction("EventTypeList").setAttribute("globalScript", this.scriptFunctions.isGlobalScript());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.tryCall(() -> ClientUtils.buildList(this.eventTypes.getList(), XMLUtils.selectNode(doc, "//list"), ""));
        }
    }

    private void save() {
        ClientUtils.showMessageDialog("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434");
    }

    private void cancelPressed() {
        if (this.saveButton.isEnabled() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?", "\u0412\u044b\u0445\u043e\u0434", 0) == 0) {
            this.save();
        }
        this.scriptFunctions.hideEditor();
    }

    @Override
    public void deleteItem() {
        if (this.bhPanel.isShowing()) {
            this.bhPanel.deleteItem();
            return;
        }
        super.deleteItem();
    }
}

