/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.interaction;

import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.plugins.dispatch.server.interaction.ModuleRequest;

public class ModuleRequestGenerator {
    private static ConcurrentHashMap<String, ModuleRequest> cache = new ConcurrentHashMap();

    public static ModuleRequest generateRequest(int moduleId) throws BGException {
        BGModule requested = ModuleCache.getInstance().getModule(moduleId);
        if (requested == null) {
            throw new BGException("module id=" + moduleId + " is not in the cache");
        }
        ModuleRequest request = cache.get(requested.getName());
        if (request == null) {
            try {
                Class<?> requestClass = Class.forName("ru.bitel.bgbilling.plugins.dispatch.modules." + requested.getName() + ".server.ModuleRequest");
                request = (ModuleRequest)requestClass.newInstance();
                cache.put(requested.getName(), request);
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return request;
    }
}

