/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.utils;

import jakarta.xml.ws.Holder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCopy;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderBillData;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderConfirmed;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.modules.license.server.mail.MailSendLicenseText;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.security.EyelessHostnameVerifier;
import ru.bitel.common.security.EyelessSSLSocketFactory;

public class LicenseUtils {
    private static Logger log = LoggerFactory.getLogger(LicenseUtils.class);
    private static NumberFormat costFormatter = NumberFormat.getCurrencyInstance();

    public static String getLicenseText(List<LicenseOrderConfirmed> copyItems, LicenseManager licenseManager, int contractId, Preferences moduleSetup, LicenseCopy copy) {
        String newLine = "\n";
        String organizationTitle = LicenseUtils.getOrganizationTitle(licenseManager, contractId, moduleSetup.getInt("license.full.organization.name.parameter.id", -1), copy.getLicenseName());
        String version = copy.getProductVersion();
        StringBuilder license = new StringBuilder("lic.kernel=bgbilling_kernel_" + contractId + "_" + version + "_" + organizationTitle + newLine);
        for (int i = 0; i < copyItems.size(); ++i) {
            LicenseOrderConfirmed item = copyItems.get(i);
            String productItemName = item.getComponentName();
            String count = String.valueOf(item.getCount());
            String toDate = TimeUtils.format((Date)item.getDateTo(), (String)"dd.MM.yyyy");
            license.append("licence.").append(productItemName).append("=bgbilling_module_").append(i + 1).append("_").append(contractId).append("_").append(productItemName).append("_").append(count).append("_").append(toDate).append(newLine);
        }
        license.append("END" + newLine);
        return license.toString();
    }

    public static String encryptLicenseText(String originalText, Preferences moduleSetup) throws IOException {
        String path = moduleSetup.get("license.encrypter.path", "/home/bill/BillingKeyGen");
        String launchString = moduleSetup.get("license.encrypter.launch.string", "cat open_lic | /home/bill/jdk/bin/java -cp .:./classes:./lib/* ru.bitel.billing.keygen.MainFrame generate generate generate");
        return LicenseUtils.encryptLicenseText(originalText, path, launchString);
    }

    public static String encryptLicenseText(String originalText, String path, String launchString) throws IOException {
        String command = launchString.replaceAll("[.]/", path + "/").replaceAll("[.]:", path + ":");
        Runtime rt = Runtime.getRuntime();
        Process p = null;
        p = rt.exec(command);
        if (log.isDebugEnabled()) {
            log.debug("License encrypting ...");
        }
        OutputStreamWriter wtr = new OutputStreamWriter(p.getOutputStream(), "cp1251");
        wtr.write(originalText);
        wtr.flush();
        byte[] errorBuf = Utils.readByBlock((InputStream)p.getErrorStream());
        String errors = new String(errorBuf, "cp1251");
        if (Utils.notBlankString((String)errors)) {
            log.error("Encryption errors: \n" + errors);
        }
        byte[] outputBuf = Utils.readByBlock((InputStream)p.getInputStream());
        return new String(outputBuf, "cp1251");
    }

    private static String getOrganizationTitle(LicenseManager licenseManager, int contractId, int fullOrganizationNameParameterId, String licenseeName) {
        String title = null;
        if (Utils.notBlankString((String)licenseeName)) {
            title = licenseeName;
        }
        String organizationTitle = licenseManager.getOrganizationTitle(contractId, fullOrganizationNameParameterId);
        if (Utils.isBlankString((String)title)) {
            title = organizationTitle;
            return title;
        }
        String contractComment = licenseManager.getContractComment(contractId);
        if (Utils.isBlankString((String)title)) {
            title = contractComment;
            return title;
        }
        return title.replace("${ORGANIZATION_TITLE}", organizationTitle).replace("${CONTRACT_COMMENT}", contractComment);
    }

    public static Map<String, BigDecimal> getCosts(String costRequestUrl) {
        HashMap<String, BigDecimal> costs = new HashMap<String, BigDecimal>();
        byte[] bytes = null;
        try {
            HttpsURLConnection connection = null;
            connection = (HttpsURLConnection)URI.create(costRequestUrl).toURL().openConnection();
            connection.setSSLSocketFactory(EyelessSSLSocketFactory.INSTANCE);
            connection.setHostnameVerifier((HostnameVerifier)EyelessHostnameVerifier.INSTANCE);
            bytes = Utils.readByBlock((InputStream)connection.getInputStream());
            Document licenseCostDoc = XMLUtils.parseDocument((byte[])bytes);
            Iterable elements = XMLUtils.selectElements((Node)licenseCostDoc, (String)"data/module");
            for (Element el : elements) {
                costs.put(el.getAttribute("name"), new BigDecimal(el.getAttribute("sum")));
            }
        }
        catch (Exception e) {
            System.err.println("costRequestUrl = " + costRequestUrl);
            System.err.println("costResultString = " + new String(bytes != null ? bytes : "".getBytes(), Charset.defaultCharset()));
            log.error("ActionGetPackageItem.getCosts()", (Throwable)e);
        }
        return costs;
    }

    public static float getCost(String costRequestUrl, Holder<Integer> holderUnlimitCount) {
        float cost = 0.0f;
        byte[] bytes = null;
        try {
            HttpsURLConnection connection = null;
            connection = (HttpsURLConnection)URI.create(costRequestUrl).toURL().openConnection();
            connection.setSSLSocketFactory(EyelessSSLSocketFactory.INSTANCE);
            connection.setHostnameVerifier((HostnameVerifier)EyelessHostnameVerifier.INSTANCE);
            InputStream is = connection.getInputStream();
            bytes = Utils.readByBlock((InputStream)is);
            Document licenseCostDoc = XMLUtils.parseDocument((byte[])bytes);
            Element element = XMLUtils.selectElement((Node)licenseCostDoc, (String)"data/module");
            if (element != null && element.getAttribute("sum") != null) {
                String sum = element.getAttribute("sum");
                float f = cost = Utils.isBlankString((String)sum) ? 0.0f : Float.valueOf(sum).floatValue();
                if (holderUnlimitCount != null) {
                    holderUnlimitCount.value = Utils.parseInt((String)element.getAttribute("unlimit_from_count"), (int)-1);
                }
            } else {
                cost = 0.0f;
            }
        }
        catch (Exception e) {
            System.err.println("costRequestUrl = " + costRequestUrl);
            System.err.println("costResultString = " + new String(bytes != null ? bytes : "".getBytes(), Charset.defaultCharset()));
            log.error("ActionGetPackageItem.getCosts()", (Throwable)e);
        }
        return cost;
    }

    public static LicenseOrderBillData getCostDelta(String itemName, Integer confirmedItemsCount, Integer itemCountDelta, String version, Preferences moduleSetup) {
        LicenseOrderBillData item = new LicenseOrderBillData();
        String costRequestUrl = LicenseUtils.buildLicenseCostUrlRequest(itemName, confirmedItemsCount, version, moduleSetup);
        item.setConfirmedCount(confirmedItemsCount);
        item.setConfirmedCost(BigDecimal.ZERO);
        item.setCountDelta(itemCountDelta);
        item.setTotalCount(Integer.valueOf(0));
        if (confirmedItemsCount != null && confirmedItemsCount >= 0) {
            item.setConfirmedCost(BigDecimal.valueOf(LicenseUtils.getCost(costRequestUrl, null)));
        }
        if (item.getConfirmedCount() == null && item.getCountDelta() == null) {
            item.setTotalCount(null);
        } else {
            if (item.getConfirmedCount() != null) {
                item.setTotalCount(Integer.valueOf(item.getTotalCount() + item.getConfirmedCount()));
            }
            if (item.getCountDelta() != null) {
                item.setTotalCount(Integer.valueOf(item.getTotalCount() + item.getCountDelta()));
            }
            if (item.getConfirmedCount() != null && item.getConfirmedCount() == 0 || item.getCountDelta() != null && item.getCountDelta() == 0) {
                item.setTotalCount(Integer.valueOf(0));
            }
        }
        costRequestUrl = LicenseUtils.buildLicenseCostUrlRequest(itemName, item.getTotalCount(), version, moduleSetup);
        item.setTotalCost(BigDecimal.valueOf(LicenseUtils.getCost(costRequestUrl, null)));
        item.setCostDelta(item.getTotalCost().subtract(item.getConfirmedCost()));
        return item;
    }

    public static String buildLicenseCostUrlRequest(List<LicenseOrderConfirmed> packageItems, String version, ParameterMap moduleSetup) {
        StringBuilder urlRequest = new StringBuilder();
        urlRequest.append(moduleSetup.get("license.cost.script.url", "https://bgbilling.ru/cgi/count.pl"));
        String versionShort = LicenseUtils.getShortVersion(version);
        for (int i = 0; i < packageItems.size(); ++i) {
            if (i == 0) {
                urlRequest.append("?version=" + versionShort + "&");
            } else {
                urlRequest.append("&");
            }
            LicenseOrderConfirmed item = packageItems.get(i);
            String count = item.getCount() > 0 ? String.valueOf(item.getCount()) : "unlimited";
            String itemName = item.getComponentName();
            urlRequest.append(itemName + "_enable=on");
            urlRequest.append("&" + itemName + "_count=" + count);
        }
        return urlRequest.toString();
    }

    public static String getShortVersion(String version) {
        return version.substring(0, version.indexOf("."));
    }

    public static String buildLicenseCostUrlRequest(LicenseOrderConfirmed item, String version, Preferences moduleSetup) {
        return LicenseUtils.buildLicenseCostUrlRequest(item.getComponentName(), item.getCount(), version, moduleSetup);
    }

    public static String buildLicenseCostUrlRequest(String itemName, Integer itemCount, String version, Preferences moduleSetup) {
        StringBuilder urlRequest = new StringBuilder();
        urlRequest.append(moduleSetup.get("license.cost.script.url", "https://bgbilling.ru/cgi/count.pl"));
        String versionShort = LicenseUtils.getShortVersion(version);
        urlRequest.append("?version=" + versionShort + "&");
        String count = itemCount == null ? "0" : (itemCount != 0 ? String.valueOf(itemCount) : "unlimited");
        urlRequest.append(itemName + "_enable=on");
        urlRequest.append("&" + itemName + "_count=" + count);
        return urlRequest.toString();
    }

    public static String formatCost(float cost) {
        return costFormatter.format(cost);
    }

    public static String sendLiceneseText(String mails, String licenseText, String subject, int moduleId) throws BGException {
        Setup setup = Setup.getSetup();
        String content = "\u0414\u043b\u044f \u0432\u0435\u0440\u0441\u0438\u0438 4.6 \u0438 \u0441\u0442\u0430\u0440\u0448\u0435: \u0444\u0430\u0439\u043b \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u044c \u0432 BGBillingServer/data/.\n\u0414\u043b\u044f \u0432\u0435\u0440\u0441\u0438\u0438 4.5 \u0438 \u043c\u043b\u0430\u0434\u0448\u0435: \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u0432\u0441\u0435 \u043a\u043b\u044e\u0447\u0438 lic.* \u0438 licence.* \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u043f\u043e\u0441\u043b\u0435 lic.key \u0432 \u0444\u0430\u0439\u043b\u0435 BGBillingServer/data/data.properties \u043d\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 lic.properties.\n\u0414\u043b\u044f \u0432\u0435\u0440\u0441\u0438\u0438 7.2+ \u0438 \u0441\u0442\u0430\u0440\u0448\u0435: \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0447\u0435\u0440\u0435\u0437 \u043a\u043b\u0438\u0435\u043d\u0442 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 \u0431\u0435\u0437 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u043c\u0435\u043d\u044e - \u0421\u043f\u0440\u0430\u0432\u043a\u0430 - \u0418\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438 - \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0438 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e";
        try {
            MailSendLicenseText mailData = new MailSendLicenseText();
            mailData.setModuleId(moduleId);
            mailData.setRecipients(mails);
            mailData.setSubject(subject);
            mailData.addTextPart("text", content);
            mailData.addPart("file", "attachment", "text/plain", "lic.properties", licenseText.getBytes("UTF-8"));
            return new MailMsg((Preferences)setup).sendMessage((MailData)mailData);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

