/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.admin.DialogContractAndDateSelect;
import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.Initable;
import bitel.billing.module.common.TransferData;
import bitel.billing.module.common.table.BGTable;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.help.HelpViewer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractTabbedPane;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.DialogContractSelect;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.TryCall;

public class BGPanel
extends JPanel
implements ActionListener {
    private int moduleId = -1;
    private int contractId = -1;
    private ClientContext context = null;
    protected boolean init = false;
    protected boolean fl = false;
    protected int id = 0;
    protected Map<String, Object> attrs = null;
    protected JDialog parentDialog = null;
    protected ClientSetup setup = null;
    protected String module = null;
    protected String rb_name = ClientUtils.getRBName(this);
    protected Document moduleDoc = null;
    protected HashSet<Initable> initable = null;

    public BGPanel() {
        this.setup = ClientSetup.getInstance();
        this.getModuleDoc(this.getClass());
    }

    public BGPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.setup = ClientSetup.getInstance();
        this.getModuleDoc(this.getClass());
    }

    public void init(String module, int moduleId) {
        this.module = module;
        this.setModuleId(moduleId);
        if (this.initable != null) {
            for (Initable item : this.initable) {
                if (item == null) continue;
                item.init(module, moduleId);
            }
        }
    }

    protected void getModuleDoc(Class<?> clazz) {
        this.moduleDoc = (Document)ClientSetup.getInstance().getObject(this.rb_name);
        if (this.moduleDoc == null) {
            this.moduleDoc = ClientUtils.getModuleDoc(clazz);
            if (this.moduleDoc != null) {
                ClientSetup.getInstance().putObject(this.rb_name, this.moduleDoc);
            }
        }
    }

    public Document getDocument(Request request) {
        return TransferManager.getDocument(request);
    }

    protected byte[] getBytes(Request request) {
        return TransferManager.getBytes(request);
    }

    protected InputStream getInputStream(Request request) {
        return TransferManager.getInputStream(request);
    }

    protected TransferData.HTTPDataSource getDataSource(Request request) {
        return TransferManager.getDataSource(request);
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setAttr(String name, Object value) {
        this.getAttrs().put(name, value);
    }

    public Map<String, Object> getAttrs() {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, Object>();
        }
        return this.attrs;
    }

    public void setContractId(int id) {
        this.contractId = id;
    }

    public int getContractId() {
        return this.contractId;
    }

    public ClientSetup getSetup() {
        return this.setup;
    }

    public void setSetup(ClientSetup setup) {
        this.setup = setup;
    }

    public String getModule() {
        return this.module;
    }

    public void setData() throws Exception {
    }

    public void trySetData() {
        try {
            this.setData();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void setDocument(Document doc) throws Exception {
    }

    public void trySetDocument(Document doc) {
        try {
            this.setDocument(doc);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void tryCall(TryCall tryCall) {
        tryCall.call();
    }

    protected void openHelp(String id) {
        new HelpViewer(BGClientBase.getFrame(), id).setVisible(true);
    }

    protected void setOpenContractsToList(JList<BGUListItem> contract) {
        ContractTabbedPane tabbedPane = BGClientBase.getFrame().getTabbedPane();
        DefaultListModel<BGUListItem> model = new DefaultListModel<BGUListItem>();
        for (int index = 0; index < tabbedPane.getComponentCount(); ++index) {
            BGTabPanel tab = (BGTabPanel)tabbedPane.getComponent(index);
            String tabID = tab.getTabId();
            if (!tabID.startsWith("contract_")) continue;
            BGUListItem item = new BGUListItem(tabID.substring(9), tab.getTabTitle());
            item.setAttribute("cid", tabID.substring(9));
            model.addElement(item);
        }
        contract.setModel(model);
    }

    public void newItem() {
        ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
    }

    public void copyItem() {
        ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
    }

    public void editItem() {
        ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
    }

    public void deleteItem() {
        ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.newItem();
        } else if ("copyItem".equals(actionCommand)) {
            this.copyItem();
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand)) {
            this.deleteItem();
        } else if ("refresh".equals(actionCommand)) {
            this.trySetData();
        }
    }

    public void addInitable(Initable item) {
        if (this.setup != null && this.module != null) {
            item.init(this.module, this.getModuleId());
        } else {
            if (this.initable == null) {
                this.initable = new HashSet();
            }
            this.initable.add(item);
        }
    }

    public void transferToContract(String action, String param, String value) {
        DialogContractSelect contractSelect = new DialogContractSelect(true, true, this.getContractId());
        contractSelect.setTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430");
        if (contractSelect.showDialog() == "ok") {
            String cidTo = contractSelect.getSingleId();
            if (Utils.isBlankString(cidTo)) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction(action);
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAttribute("cid_to", cidTo);
            request.setAttribute(param, value);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.trySetData();
            }
        }
        contractSelect.dispose();
    }

    public void wrapToContract(String action, String param, String value) {
        DialogContractAndDateSelect contractSelect = new DialogContractAndDateSelect(this.getContractId());
        contractSelect.setTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438 \u0434\u0430\u0442\u0443 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430");
        if (contractSelect.showDialog() == "ok") {
            String cidTo = contractSelect.getSingleId();
            String date = contractSelect.getDateString();
            if (Utils.isBlankString(cidTo)) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                return;
            }
            if (Utils.isBlankString(date)) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0434\u0430\u0442\u0430");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction(action);
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAttribute("cid_to", cidTo);
            request.setAttribute("from_date", date);
            request.setAttribute(param, value);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.trySetData();
            }
        }
        contractSelect.dispose();
    }

    protected JPopupMenu createPopupMenu(final BGTable table) {
        final JPopupMenu result = new JPopupMenu();
        table.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                    result.show(table, e.getX(), e.getY());
                }
            }
        });
        return result;
    }

    protected void initTransferContractPopup(JPopupMenu popupMenu, BGUTable table, String action, String tableId, String param) {
        JMenuItem transferItem = new JMenuItem("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        popupMenu.add(transferItem);
        transferItem.addActionListener(e -> {
            String id = ((BGTableModel)table.getModel()).getValueFromSelectedRow("id");
            if (id != null) {
                this.transferToContract(action, param, id);
            }
        });
    }

    protected void initTransferContractPopup(JPopupMenu popupMenu, BGTable table, String action, String tableId, String param) {
        JMenuItem transferItem = new JMenuItem("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        popupMenu.add(transferItem);
        transferItem.addActionListener(e -> {
            String id = ClientUtils.getRowId(table, null, tableId);
            if (id != null) {
                this.transferToContract(action, param, id);
            }
        });
    }

    protected void initWrapContractPopup(JPopupMenu popupMenu, BGTable table, String action, String tableId, String param) {
        JMenuItem wrapItem = new JMenuItem("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0434\u0430\u0442\u044b");
        popupMenu.add(wrapItem);
        wrapItem.addActionListener(e -> {
            String id = ClientUtils.getRowId(table, null, tableId);
            if (id != null) {
                this.wrapToContract(action, param, id);
            }
        });
    }

    protected void initWrapContractPopup(JPopupMenu popupMenu, BGUTable table, String action, String tableId, String param) {
        JMenuItem wrapItem = new JMenuItem("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0434\u0430\u0442\u044b");
        popupMenu.add(wrapItem);
        wrapItem.addActionListener(e -> {
            String id = ((BGTableModel)table.getModel()).getValueFromSelectedRow("id");
            if (id != null) {
                this.wrapToContract(action, param, id);
            }
        });
    }

    public ClientContext getKernelContext() {
        return new ClientContext("kernel", 0, this.getContractId(), null);
    }

    public ClientContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        Container parent = this;
        while ((parent = parent.getParent()) != null) {
            if (parent instanceof AbstractBGUPanel) {
                this.context = (ClientContext)((AbstractBGUPanel)parent).getContext();
                return this.context;
            }
            if (!(parent instanceof BGPanel)) continue;
            this.context = ((BGPanel)parent).getContext();
            return this.context;
        }
        this.context = ClientContext.get();
        if (this.context == null) {
            this.context = new ClientContext(this.module, this.getModuleId(), this.getContractId(), this.rb_name, this.moduleDoc);
        }
        return this.context;
    }

    protected String getUserEmail(String key) {
        List<String> email = this.setup.getUserEmail(key);
        return Utils.toString(email, ",");
    }

    protected void saveUserEmail(String key, String email) {
        this.setup.saveUserEmail(key, Utils.toList(email));
    }

    public void setContext(ClientContext context) {
        this.context = context;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int id) {
        this.moduleId = id;
    }

    public String getRbName() {
        return this.rb_name;
    }
}

