/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.tariff;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptServiceCost;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class PacketsAutosyncTariffTreeNode
extends ModuleServiceTariffTreeNode<CerbercryptTariffContext, CerbercryptServiceCost, CerbercryptTariffRequest> {
    private Set<Integer> packets = null;
    private boolean onCardAdd;
    private boolean onTariffChange;

    public PacketsAutosyncTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.packets = Collections.unmodifiableSet(new HashSet(Utils.toIntegerList((String)parameterMap.get("packets"))));
        this.onCardAdd = parameterMap.getBoolean("on_card_add", false);
        this.onTariffChange = parameterMap.getBoolean("on_tariff_change", false);
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, CerbercryptTariffRequest tariffRequest, TariffTreeNodeHolder holder, CerbercryptTariffContext tariffContext, TreeContext treeContext, ThreadContext workerContext) {
        if (tariffRequest.isCheckPacketsAutoSync()) {
            tariffRequest.setPacketsAutoSync(this.packets);
            tariffRequest.setPacketsAutoSyncOnCardAdd(this.onCardAdd);
            tariffRequest.setPacketsAutoSyncOnTariffChange(this.onTariffChange);
        }
        return 1;
    }
}

