<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:utils="ru.bitel.common.Utils"
	xmlns:common="http://common.bitel.ru"
	version="1.0">

	<xsl:output method="html" encoding="UTF-8" indent="yes" />
	<xsl:decimal-format name="ru" decimal-separator="," grouping-separator=" " />	
	<xsl:decimal-format name="summa" decimal-separator="." grouping-separator=" "/>

	<xsl:variable name="unit"><xsl:value-of select="/data/@unit"/></xsl:variable>
	<xsl:variable name="trafficFormat">
		<xsl:choose>
				<xsl:when test="$unit = 1 ">### ### #####0</xsl:when>
				<xsl:otherwise>### ### #####0.000</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="/">
		<html>
			<head>
			</head>
			<body>
				<style>
					body, table { font-size: 10pt;}
					.right { text-align: right; }
					td { text-align: center; }
				</style>
				<center>
					<xsl:call-template name="head" />
					<br />
					<xsl:call-template name="table" />
				</center>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="head">
		<h2>Отчет по сессиям<br />Договор:&#160;<xsl:value-of select="/data/@contractTitle" />(<xsl:value-of select="/data/@comment" />)</h2>
		<div><xsl:value-of select="/data/@service" />&#160;Период с: <xsl:value-of select="/data/@dateFrom" /> по <xsl:value-of select="/data/@dateTo" /></div>
	</xsl:template>

	<xsl:template name="table">
		<table width="100%" border="1" cellspacing="0" cellpadding="3">
			<tr bgcolor="#f0f0f0">
				<th>Устройство</th>
				<th>Порт</th>
				<th>Сервис</th>
				<th>C номера/На номер</th>
				<th>IP</th>
				<th>Время входа</th>
				<th>Время выхода</th>
				<th>Активность</th>
				<th>Сумма, руб.</th>
				<th>Статус</th>
				<xsl:for-each select="/data/trafficTypes/data/item">
					<th>
						<xsl:value-of select="@title" />
						<xsl:choose>
							<xsl:when test="$unit = 1024 ">, Кб </xsl:when>
							<xsl:when test="$unit = 1048576 ">, Мб </xsl:when>
							<xsl:when test="$unit = 1073741824 ">, Гб </xsl:when>
							<xsl:otherwise>, байт</xsl:otherwise>
						</xsl:choose>
					</th>
				</xsl:for-each>
			</tr>
			<xsl:for-each select="/data/common:result/data/item">
			<xsl:variable name="count" select="position()"/>
			<tr>
				<td><xsl:value-of select="@deviceId" /></td>
				<td><xsl:value-of select="@devicePort" /></td>
				<td>
					<xsl:variable name="serviceId">
						<xsl:value-of select="@servId" />
					</xsl:variable>
		
					<xsl:for-each select="/data/servs/data/item">
						<xsl:if test="@id=$serviceId">
							<xsl:value-of select="@title" />
						</xsl:if>
					</xsl:for-each>
				</td>
				<td><xsl:if test="@cdsId"><xsl:value-of select="@cdsId" /> / <xsl:value-of select="@cnsId" /></xsl:if></td>
				<td><xsl:value-of select="@ip" /></td>
				<td><xsl:value-of select="@start" /></td>
				<td><xsl:value-of select="@stop" /></td>
				<td><xsl:value-of select="@last" /></td>
				<td class="right"><xsl:value-of select="@cost" /></td>
				<td><xsl:value-of select="@statusName" /></td>
				
				<xsl:variable name="session" select="."/>
		
				<xsl:for-each select="/data/trafficTypes/data/item">
					<td class="right">
					<xsl:variable name="typeId"><xsl:value-of select="@id"/></xsl:variable>
					<xsl:variable name="val" select="$session/trafficMap/entry[key/text()=$typeId]/value/text() + sum($session/children/child/trafficMap/entry[key/text()=$typeId]/value/text())"/>
					<xsl:choose>
						<xsl:when test="$val!=$val or $val=''">0</xsl:when>
						<xsl:when test="$typeId=0"><xsl:value-of select="utils:formatSessionTime( $val )"/></xsl:when>
						<xsl:otherwise>
							<xsl:variable name="val2" select="format-number($val, '#.000') div $unit"/>
							<xsl:value-of select="format-number(($val2), $trafficFormat, 'summa')"/>
						</xsl:otherwise>
					</xsl:choose>
					</td>
				</xsl:for-each>
			</tr>
		</xsl:for-each>
 		<tr>
			<td colspan="7">Итого сессий:&#160;<xsl:value-of select="/data/common:result/attributes/item[@key='totalCount']/value"/></td>	
			<td></td>	
			<td class="right"><xsl:value-of select="format-number(/data/common:result/attributes/item[@key='totalCost']/value, '### ### ##0,00', 'ru')"/></td>
			<td>&#160;</td>			
			<xsl:for-each select="/data/trafficTypes/data/item">
				<td class="right">
				<xsl:variable name="typeId"><xsl:value-of select="@id"/></xsl:variable>
				<xsl:variable name="val" select="number(/data/common:result/attributes/item[@key='totalTraffics']/value/data/entry[key=$typeId]/value)"/>
				
				<xsl:choose>
					<xsl:when test="$val!=$val or $val=''">0</xsl:when>
					<xsl:when test="$typeId=0"><xsl:value-of select="utils:formatSessionTime( $val )"/></xsl:when>
					<xsl:otherwise>
						<xsl:variable name="val2" select="format-number($val, '#.000') div $unit"/>
						<xsl:value-of select="format-number(($val2), $trafficFormat, 'summa')"/>
					</xsl:otherwise>
				</xsl:choose>
				</td>
			</xsl:for-each>
		</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>