/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.device;

import bsh.EvalError;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptMethod;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceTypeScriptMethod;
import ru.bitel.common.Utils;

public class InetDeviceTypeScript
extends ReentrantLock {
    private static final Logger logger = LogManager.getLogger();
    private static final ScriptMethod nullMethod = new ScriptMethod(){

        public Object invoke(Object[] args) throws BGException {
            return null;
        }
    };
    public final int deviceId;
    protected final Set<String> methods;
    public final ScriptMethod init;
    public final ScriptMethod destroy;
    public final ScriptMethod finalize;
    public final ScriptMethod serviceCreate;
    public final ScriptMethod serviceModify;
    public final ScriptMethod serviceCancel;
    public final ScriptMethod connectionModify;
    public final ScriptMethod connectionClose;
    public final ScriptMethod onAccountingStart;
    public final ScriptMethod onAccountingStop;

    public InetDeviceTypeScript(int deviceId, Script script, Map<String, Object> params) {
        Set methods;
        this.deviceId = deviceId;
        if (Utils.isBlankString((String)script.getScript()) || (methods = ScriptInstance.methodNames((Script)script)).size() == 0) {
            this.init = nullMethod;
            this.destroy = nullMethod;
            this.finalize = nullMethod;
            this.serviceCreate = nullMethod;
            this.serviceModify = nullMethod;
            this.serviceCancel = nullMethod;
            this.connectionModify = nullMethod;
            this.connectionClose = nullMethod;
            this.onAccountingStart = nullMethod;
            this.onAccountingStop = nullMethod;
            this.methods = Collections.emptySet();
            if (logger.isDebugEnabled()) {
                logger.debug("Script for device: " + deviceId + " is empty.");
            }
            return;
        }
        this.methods = methods;
        ScriptMethod init = nullMethod;
        ScriptMethod destroy = nullMethod;
        ScriptMethod finalize = nullMethod;
        ScriptMethod serviceCreate = nullMethod;
        ScriptMethod serviceModify = nullMethod;
        ScriptMethod serviceCancel = nullMethod;
        ScriptMethod connectionModify = nullMethod;
        ScriptMethod connectionClose = nullMethod;
        ScriptMethod onAccountingStart = nullMethod;
        ScriptMethod onAccountingStop = nullMethod;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ScriptInstance instance = new ScriptInstance(script);
            instance.eval(new PrintStream(out), new PrintStream(err), params);
            if (out.size() > 0) {
                logger.info(out.toString());
            }
            if (err.size() > 0) {
                logger.error(err.toString());
            }
            init = methods.contains("init") ? new InetDeviceTypeScriptMethod(instance, "init") : nullMethod;
            destroy = methods.contains("destroy") ? new InetDeviceTypeScriptMethod(instance, "destroy") : nullMethod;
            finalize = methods.contains("finalize") ? new InetDeviceTypeScriptMethod(instance, "finalize") : nullMethod;
            serviceCreate = methods.contains("serviceCreate") ? new InetDeviceTypeScriptMethod(instance, "serviceCreate") : nullMethod;
            serviceModify = methods.contains("serviceModify") ? new InetDeviceTypeScriptMethod(instance, "serviceModify") : nullMethod;
            serviceCancel = methods.contains("serviceCancel") ? new InetDeviceTypeScriptMethod(instance, "serviceCancel") : nullMethod;
            connectionModify = methods.contains("connectionModify") ? new InetDeviceTypeScriptMethod(instance, "connectionModify") : nullMethod;
            connectionClose = methods.contains("connectionClose") ? new InetDeviceTypeScriptMethod(instance, "connectionClose") : nullMethod;
            onAccountingStart = methods.contains("onAccountingStart") ? new InetDeviceTypeScriptMethod(instance, "onAccountingStart") : nullMethod;
            onAccountingStop = methods.contains("onAccountingStop") ? new InetDeviceTypeScriptMethod(instance, "onAccountingStop") : nullMethod;
        }
        catch (EvalError e) {
            logger.error(e.getMessage(), (Throwable)e);
            String key = "inet.access.script";
            AlarmSender.sendAlarm((String)key, (long)100L, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 BGBS \u0441\u043a\u0440\u0438\u043f\u0442\u0430 \u043f\u0440\u0435\u0434\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 RADIUS \u0437\u0430\u043f\u0440\u043e\u0441\u0430", (String)"", (Throwable)e);
        }
        this.init = init;
        this.destroy = destroy;
        this.finalize = finalize;
        this.serviceCreate = serviceCreate;
        this.serviceModify = serviceModify;
        this.serviceCancel = serviceCancel;
        this.connectionModify = connectionModify;
        this.connectionClose = connectionClose;
        this.onAccountingStart = onAccountingStart;
        this.onAccountingStop = onAccountingStop;
    }
}

