/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionAutoRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;

public class ServTrackingWorker
extends AccountingWorkerTask {
    private static final Logger logger = LogManager.getLogger();
    private final Accounting accounting;
    private final Set<Integer> servTypeIds;
    private Iterator<InetServRuntime> iterator;
    private boolean accountingPeriodActivate;
    private final FrequencyCounter trackedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private static final ThreadLocal<Boolean> workerThread = new ThreadLocal();

    public ServTrackingWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, ParameterMap params, ParameterMap defaultParams) {
        super(scheduledExecutorService, "", params, defaultParams);
        this.accounting = accounting;
        this.accountingPeriodActivate = params.getInt("accountingPeriodActivate", defaultParams.getInt("accountingPeriodActivate", 0)) > 0;
        Set servTypeIds = Utils.toIntegerSet((String)params.get("servTypeIds", null));
        this.servTypeIds = servTypeIds == null || servTypeIds.size() == 0 ? null : servTypeIds;
        logger.info("Add serv tracking worker: delay={}, batchSize={}, accountingPeriodActivate={}", (Object)this.getDelay(), (Object)this.batchSize, (Object)this.accountingPeriodActivate);
    }

    public static boolean isWorkerThread() {
        return workerThread.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() throws BGException {
        logger.trace("Run serv tracker...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.accounting.getInetServRuntimeMap().values().iterator();
        }
        EventProcessor ep = EventProcessor.getInstance();
        long millis = System.currentTimeMillis();
        ConnectionSet connectionSet = ((ServerContext)this.context).getConnectionSet();
        InetDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        int count = 0;
        workerThread.set(Boolean.TRUE);
        try {
            int size = this.batchSize;
            while (count < size && this.iterator.hasNext()) {
                InetServRuntime inetServRuntime = this.iterator.next();
                if (!ServTrackingWorker.process0(this.accounting, connectionSet, ep, rootDeviceRuntime, inetServRuntime, millis, this.servTypeIds, true, this.accountingPeriodActivate, 100L)) continue;
                ++count;
            }
        }
        finally {
            workerThread.remove();
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.trackedPerMinute.add(millis2, (long)count);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (logger.isDebugEnabled() && count > 0) {
            logger.debug("Tracked " + count + " servs for " + duration + " ms.");
        }
    }

    public static boolean process(Accounting accounting, ConnectionSet connectionSet, EventProcessor ep, InetServRuntime inetServRuntime, long millis, boolean accountingPeriodActivate, long lockWaitTimeout) throws BGException {
        return ServTrackingWorker.process0(accounting, connectionSet, ep, null, inetServRuntime, millis, null, false, accountingPeriodActivate, lockWaitTimeout);
    }

    private static boolean process0(Accounting accounting, ConnectionSet connectionSet, EventProcessor ep, InetDeviceRuntime rootDeviceRuntime, InetServRuntime inetServRuntime, long millis, Set<Integer> servTypeIds, boolean checkSessions, boolean accountingPeriodActivate, long lockWaitTimeout) throws BGException {
        InetServ inetServ;
        block20: {
            inetServ = inetServRuntime.getInetServ();
            if (inetServ.getParentId() > 0) {
                return false;
            }
            if (inetServ.getDeviceState() != InetServState.STATE_ENABLE.getCode()) {
                return false;
            }
            if (servTypeIds != null && !servTypeIds.contains(inetServ.getTypeId())) {
                return false;
            }
            if (rootDeviceRuntime != null && inetServ.getDeviceId() != rootDeviceRuntime.inetDeviceId.intValue() && !rootDeviceRuntime.descendantIds.contains(inetServ.getDeviceId())) {
                return false;
            }
            if (!RangeUtils.inRange((long)millis, (long)millis, (long)inetServRuntime.getDateFromMillis(), (long)inetServRuntime.getDateToMillis())) {
                return false;
            }
            if (checkSessions && ServTrackingWorker.haveSessions(accounting, inetServRuntime)) {
                return false;
            }
            if (lockWaitTimeout > 0L) {
                try {
                    if (!inetServRuntime.tryLock(lockWaitTimeout, TimeUnit.MILLISECONDS)) {
                        return false;
                    }
                    break block20;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            inetServRuntime.lock();
        }
        try {
            inetServ = inetServRuntime.getInetServ();
            if (inetServ.getDeviceState() != InetServState.STATE_ENABLE.getCode()) {
                boolean ex = true;
                return ex;
            }
            if (accountingPeriodActivate) {
                inetServRuntime.accountingPeriodCheck(accounting, connectionSet, millis, true, true);
            }
            Set<Integer> newOptions = accounting.inetServOptionSet(connectionSet, millis, inetServRuntime, null);
            if (inetServ.getDeviceOptions().equals(newOptions)) {
                boolean bl = true;
                return bl;
            }
            inetServRuntime.processOptionsModified(accounting, millis, newOptions, ServTrackingWorker.class.getSimpleName());
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            inetServRuntime.unlock();
        }
        return true;
    }

    private static boolean haveSessions(Accounting accounting, InetServRuntime inetServRuntime) {
        if (ServTrackingWorker.haveSessions0(accounting, inetServRuntime)) {
            return true;
        }
        List<InetServRuntime> children = accounting.getInetServRuntimeMap().listChildren(inetServRuntime.inetServId);
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                InetServRuntime child = children.get(i);
                if (!ServTrackingWorker.haveSessions0(accounting, child)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean haveSessions0(Accounting accounting, InetServRuntime inetServRuntime) {
        InetConnectionAutoRuntime autoConnection;
        List<InetConnectionCallRuntime> callConnections = accounting.connectionMapCall.getByServId(inetServRuntime.inetServId);
        if (callConnections != null && callConnections.size() > 0) {
            return true;
        }
        ConcurrentMap<Integer, InetConnectionAutoRuntime> deviceMap = accounting.connectionMapAuto.getDeviceMap(inetServRuntime.getInetServ().getDeviceId());
        return deviceMap != null && (autoConnection = (InetConnectionAutoRuntime)((Object)deviceMap.get(inetServRuntime.inetServId))) != null && autoConnection.connection != null;
    }

    @MBeanAttribute
    public long getTrackedPerMinute() {
        return this.trackedPerMinute.get(System.currentTimeMillis());
    }
}

