/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory.warehouse;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.shop.client.directory.warehouse.WarehouseEditorPanel;
import ru.bitel.bgbilling.plugins.shop.client.directory.warehouse.WarehouseListPanel;
import ru.bitel.bgbilling.plugins.shop.common.bean.Warehouse;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseOperationService;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseService;
import ru.bitel.common.client.AbstractBGUPanel;

public class WarehousePanel
extends BGUPanel {
    private WarehouseListPanel warehouseListPanel;
    private WarehouseEditorPanel warehouseEditorPanel;
    private WarehouseService warehouseService;
    private WarehouseOperationService warehouseOperationService;

    protected void jbInit() throws Exception {
        this.warehouseListPanel = new WarehouseListPanel(this);
        this.warehouseEditorPanel = new WarehouseEditorPanel(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.warehouseListPanel, (Component)this.warehouseEditorPanel, 400L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected WarehouseService getWarehouseService() {
        if (this.warehouseService == null) {
            this.warehouseService = (WarehouseService)((ClientContext)this.getContext()).getPort(WarehouseService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.warehouseService;
    }

    protected WarehouseOperationService getWarehouseOperationService() {
        if (this.warehouseOperationService == null) {
            this.warehouseOperationService = (WarehouseOperationService)((ClientContext)this.getContext()).getPort(WarehouseOperationService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.warehouseOperationService;
    }

    protected WarehouseListPanel getWarehouseListPanel() {
        return this.warehouseListPanel;
    }

    protected WarehouseEditorPanel getWarehouseEditorPanel() {
        return this.warehouseEditorPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.warehouseEditorPanel.openEditor(null));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            Warehouse selected = this.warehouseListPanel.getSelectedWarehouseOrShowError();
            if (selected != null) {
                this.warehouseEditorPanel.openEditor(selected);
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Warehouse selected = this.warehouseListPanel.getSelectedWarehouseOrShowError();
            if (selected != null && ClientUtils.confirmDelete((Object)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u043a\u043b\u0430\u0434\u0430 \u043f\u0440\u0438\u0432\u0435\u0434\u0451\u0442 \u043a \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044e \u0432\u0441\u0435\u0445 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0432 \u043d\u0435\u0433\u043e \u0442\u043e\u0432\u0430\u0440\u043e\u0432. \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043a\u043b\u0430\u0434?", (boolean)false)) {
                this.getWarehouseService().deleteWarehouse(selected.getId());
            }
        });
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.warehouseListPanel.reloadList();
            this.warehouseEditorPanel.clearEditor();
            this.warehouseEditorPanel.getEditorPanel().setVisible(false);
        });
    }
}

