/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server;

import jakarta.annotation.Resource;
import jakarta.servlet.ServletContext;
import jakarta.xml.ws.WebServiceContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.ws.server.AbstractJaxWsHandler;
import ru.bitel.bgbilling.kernel.container.ws.server.ModuleKey;
import ru.bitel.common.Utils;

public class MPSJaxWsHandler
extends AbstractJaxWsHandler {
    public static final String URL_PREFIX = "/mps-ws";
    @Resource
    private WebServiceContext wsContext;

    public MPSJaxWsHandler(ServletContext context) throws BGException {
        super(context);
    }

    protected Class<?> findEndpointClass(ModuleKey moduleKey) {
        int lastPointIndex = moduleKey.module.lastIndexOf(".");
        String serverPackage = moduleKey.module.substring(0, lastPointIndex);
        String paymentSystem = moduleKey.module.substring(lastPointIndex + 1, moduleKey.module.length());
        String clazzName = serverPackage + ".server.bean.ws." + paymentSystem + "." + moduleKey.service + "Impl";
        try {
            return Class.forName(clazzName);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    protected String getUrlPatternName(ModuleKey moduleKey, Class<?> implementorClass) {
        return "/mpsexecuter/mps-ws/" + moduleKey.module + "/" + moduleKey.moduleId + "/" + moduleKey.service + "/" + moduleKey.entityId;
    }

    protected ModuleKey getModuleKey(String pathInfo) {
        String[] pathItems;
        ModuleKey result = null;
        if (pathInfo != null && (pathItems = patternSlash.split(pathInfo)).length == 6) {
            String module = pathItems[2];
            int mid = Utils.parseInt((String)pathItems[3]);
            String service = pathItems[4];
            int eId = Utils.parseInt((String)pathItems[5]);
            result = new ModuleKey(module, mid, service, eId);
        }
        return result;
    }
}

