/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.info;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;

public class StringInfo
extends RadiusAttributeInfo<String> {
    protected static final Charset UTF8 = Charset.forName("UTF-8");

    public StringInfo(int vendor, int code, String name, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 2, attr, children);
    }

    public StringInfo(int vendor, int code, String name, int tag, int paramTypeSize, int paramLengthSize, boolean continuation, boolean addAvpName, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 1, tag, paramTypeSize, paramLengthSize, continuation, addAvpName, children);
    }

    @Override
    public String unwrapValue(ByteBuffer data) {
        int pos;
        String value = UTF8.decode(data).toString();
        data.rewind();
        if (this.vendor != -1 && this.addAvpName && value != null && (pos = value.indexOf("=")) > 0) {
            return value.substring(pos + 1);
        }
        return value;
    }

    @Override
    public ByteBuffer wrapValue(String value) {
        ByteBuffer result;
        if (this.vendor != -1 && this.addAvpName && this.addAvpName) {
            value = this.name.toLowerCase() + "=" + (String)value;
        }
        if ((result = UTF8.encode((String)value)).limit() > 252) {
            result.limit(252);
        }
        return result.slice();
    }
}

