/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.sql.Connection;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetConnectionDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetConnectionDeviceStateAndOptionsModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetServDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.access.InetServDeviceStateAndOptionsModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.EventWorker;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class InetDeviceStateAndOptionsDatabaseWorker
extends EventWorker {
    private static final Logger logger = LogManager.getLogger();
    private final InetApplication application;
    private InetServDao inetServDao = null;
    private InetConnectionDao inetConnectionDao = null;

    public InetDeviceStateAndOptionsDatabaseWorker(InetApplication application, ScheduledExecutorService scheduledExecutorService) throws BGException {
        super(scheduledExecutorService, new LinkedBlockingDeque<Object>(1000), 50, 500, 20000L);
        this.application = application;
        this.link();
    }

    @Override
    protected void linkImpl() throws BGException {
        EventProcessor ep = EventProcessor.getInstance();
        ep.addListener((EventListener)this, InetServDeviceStateAndOptionsModifyEvent.class, this.application.moduleId, null);
        ep.addListener((EventListener)this, InetConnectionDeviceStateAndOptionsModifyEvent.class, this.application.moduleId, null);
    }

    @Override
    protected void runWorker() throws BGException {
        Connection con = this.application.setup.getDBConnectionFromPool();
        try {
            this.inetServDao = new InetServDao(con, this.application.moduleId);
            this.inetConnectionDao = new InetConnectionDao(con, this.application.moduleId);
            this.doTasks(500L);
        }
        finally {
            this.inetServDao = null;
            ServerUtils.closeConnection((Connection)con);
        }
    }

    @Override
    public void doTask(Object task) throws BGException {
        if (task instanceof InetServDeviceStateAndOptionsModifyEvent) {
            InetServDeviceStateAndOptionsModifyEvent e = (InetServDeviceStateAndOptionsModifyEvent)task;
            this.inetServDao.updateDeviceStateAndOptions(e.getInetServId(), e.getDeviceState(), e.getDeviceOptions(), e.getAccessCode());
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully updated serv state and/or options. Sending event to update runtime");
            }
            EventProcessor.getInstance().publish((Event)new InetServDeviceStateAndOptionsModifiedEvent(e));
        } else if (task instanceof InetConnectionDeviceStateAndOptionsModifyEvent) {
            InetConnectionDeviceStateAndOptionsModifyEvent e = (InetConnectionDeviceStateAndOptionsModifyEvent)task;
            this.inetConnectionDao.updateDeviceStateAndOptions(e.getDeviceId(), e.getConnectionId(), e.getDeviceState(), e.getDeviceOptions(), e.getAccessCode());
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully updated device state and/or options. Sending event to update runtime");
            }
            EventProcessor.getInstance().publish((Event)new InetConnectionDeviceStateAndOptionsModifiedEvent(e));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
    }
}

